/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.helpers;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.container.ContainerServices;
import alma.archive.ArchiveSubsystemMasterIF;
import alma.archive.ArchiveSubsystemMasterIFHelper;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.ArchiveCommunicationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;

public class InternalCommunicationHelper {
    protected static final String masterName = "ARCHIVE_MASTER_COMP";
    protected static ArchiveSubsystemMasterIF master = null;

    public static void notifyMaster(ModuleCriticalException e, ContainerServices cs, String compName, Logger logger) throws ArchiveCommunicationException {
        if (cs == null) {
            logger.fine("no container services - can't notify the master about our exception.");
        } else {
            if (master == null) {
                try {
                    master = ArchiveSubsystemMasterIFHelper.narrow((Object)cs.getComponent(masterName));
                }
                catch (AcsJContainerServicesEx e1) {
                    logger.log(Level.WARNING, "Could not connect to Archive subsystem master component. Critical exception occured, master could not be notified.", e1);
                    throw new ArchiveCommunicationException((Throwable)e1);
                }
            }
            master.componentNeedsAttention(compName, e.getTroubleCode(), e.getTroubleMessage());
        }
    }
}

