/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.ivoa.registry.RegistryAccessException;
import uk.ac.starlink.vo.RegistryQuery;

public class RegistrySelector
extends JPanel {
    private final JComboBox comboBox_ = new JComboBox(){

        public Dimension getPreferredSize() {
            Dimension size = new Dimension(super.getPreferredSize());
            size.width = Math.min(size.width, 400);
            return size;
        }

        public void configureEditor(ComboBoxEditor editor, Object item) {
            super.configureEditor(editor, item);
            Component comp = editor.getEditorComponent();
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setCaretPosition(0);
            }
        }
    };
    private final Action updateAction_;
    public static final String[] KNOWN_REGISTRIES = new String[]{RegistryQuery.AG_REG, RegistryQuery.NVO_REG};
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public RegistrySelector() {
        this.comboBox_.setModel(new DefaultComboBoxModel<String>(KNOWN_REGISTRIES));
        this.comboBox_.setEditable(true);
        this.comboBox_.setSelectedIndex(0);
        this.comboBox_.setToolTipText("Endpoint of VOResource 1.0 registry service");
        this.updateAction_ = new AbstractAction("Update"){

            public void actionPerformed(ActionEvent evt) {
                final String reg = (String)RegistrySelector.this.comboBox_.getSelectedItem();
                RegistrySelector.this.updateAction_.setEnabled(false);
                new Thread("Registry search"){

                    public void run() {
                        try {
                            final String[] acurls = RegistryQuery.getSearchableRegistries(reg);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    RegistrySelector.this.updateAction_.setEnabled(true);
                                    RegistrySelector.this.updateSelector(acurls);
                                }
                            });
                        }
                        catch (RegistryAccessException e) {
                            logger_.warning("Registry search failed: " + (Object)((Object)e));
                        }
                    }
                }.start();
            }
        };
        this.updateAction_.putValue("ShortDescription", "Search the registry for searchable registries, and update options in the selector");
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("Registry: "));
        this.add(this.comboBox_);
        this.add(Box.createHorizontalStrut(5));
        this.add(new JButton(this.updateAction_));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBox_.setEnabled(enabled);
    }

    public String getUrl() {
        return (String)this.comboBox_.getSelectedItem();
    }

    private void updateSelector(String[] acurls) {
        Vector<String> vec = new Vector<String>();
        vec.addAll(Arrays.asList(KNOWN_REGISTRIES));
        vec.addAll(Arrays.asList(acurls));
        Dimension size = this.comboBox_.getPreferredSize();
        this.comboBox_.setModel(new DefaultComboBoxModel(vec));
        this.comboBox_.setPreferredSize(size);
    }
}

