/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.client;

import alma.ArchiveIdentifierError.wrappers.AcsJArchiveIdentifierErrorEx;
import alma.acs.component.client.ComponentClient;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.EntityDirtyException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.ResultStruct;
import jakarta.mail.MessagingException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Logger;

public final class archiveQueryClient {
    private archiveQueryClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, UserDoesNotExistException, MalformedURIException, ModuleCriticalException, ArchiveException, URISyntaxException, IOException, MessagingException, AcsJArchiveIdentifierErrorEx {
        int ngasPort;
        String testDirectory_s;
        if (args.length < 1) {
            System.out.println("ERROR: Wrong number of arguments!");
            archiveQueryClient.displayHelp();
            return;
        }
        AcsLogger logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("DatabaseWriter", false);
        InternalIF xmlstore = InternalIFFactory.getInternalIF((Logger)logger);
        xmlstore.init();
        DBConfiguration dbConfig = DBConfiguration.instance((Logger)logger);
        boolean storeInNgast = false;
        String testDirectory = System.getProperty("ACS.tmp");
        String storeInNgast_s = dbConfig.get("archive.ngast.storeInNgast");
        if ("True".equalsIgnoreCase(storeInNgast_s)) {
            storeInNgast = true;
        }
        if (!"".equalsIgnoreCase(testDirectory_s = dbConfig.get("archive.ngast.testDir"))) {
            testDirectory = testDirectory_s;
        }
        String ngasServer = dbConfig.get("archive.ngast.server");
        int n = ngasPort = dbConfig.get("archive.ngast.port") == null ? 7777 : Integer.parseInt(dbConfig.get("archive.ngast.port"));
        if (args[0].indexOf("i") != -1) {
            System.out.println(InternalIFFactory.dbConfig.toString());
            return;
        }
        if (args[0].indexOf("h") != -1) {
            archiveQueryClient.displayHelp();
            return;
        }
        int indexAfterQuery = 2;
        if (args[0].indexOf("q") != -1) {
            String query;
            if (args.length < 3) {
                System.out.println("ERROR: Wrong number of arguments!");
                archiveQueryClient.displayHelp();
                return;
            }
            if (args[1].startsWith("{")) {
                int i;
                StringBuffer queryBuf = new StringBuffer();
                for (i = 1; i < args.length && !args[i - 1].endsWith("}"); ++i) {
                    queryBuf.append(args[i]).append(" ");
                }
                if (queryBuf.charAt(queryBuf.length() - 2) != '}') {
                    System.out.println("ERROR: no closing } found.");
                    archiveQueryClient.displayHelp();
                    return;
                }
                indexAfterQuery = i;
                query = queryBuf.toString().substring(1, queryBuf.length() - 2);
            } else {
                query = args[1];
            }
            if (query.startsWith("\"") && query.endsWith("\"")) {
                query = query.substring(1, query.length() - 1);
            }
            FileWriter out = null;
            if (args.length > indexAfterQuery + 1 && args[indexAfterQuery + 1].indexOf("w") != -1) {
                out = new FileWriter(args[indexAfterQuery + 2]);
                System.out.println("Writing matching XML files contents to file " + args[indexAfterQuery + 2]);
            }
            SchemaManager smanager = InternalIFFactory.getInternalIF((Logger)logger).getSchemaManager("archiveClient");
            URI schemaURI = smanager.getSchemaURI(args[indexAfterQuery]);
            Map<String, String> namespaces = smanager.getSchemaNamespaces(schemaURI);
            for (String key : namespaces.keySet()) {
                System.out.println(key + " : " + namespaces.get(key));
            }
            DBCursor cursor = xmlstore.query(query, args[indexAfterQuery], namespaces, false, "archiveClient");
            while (cursor.hasNext()) {
                ResultStruct next = cursor.next();
                System.out.println(next.getUri());
                if (out == null) continue;
                out.write(next.getXml());
            }
            if (out != null) {
                out.close();
            }
            cursor.close();
            return;
        }
        if (args[0].indexOf("x") != -1) {
            if (args.length != 2) {
                System.out.println("ERROR: Wrong number of arguments!");
                archiveQueryClient.displayHelp();
                return;
            }
            System.out.println(xmlstore.get(new URI(args[1]), "archiveClient"));
        }
        if (args[0].indexOf("c") != -1) {
            xmlstore.cleanTestArea("directClient");
            if (System.getProperty("ACS.manager") != null) {
                String managerLoc = System.getProperty("ACS.manager").trim();
                System.out.println("Archive SchemaLoader: Trying to inform ACS components.");
                AcsClient client = null;
                try {
                    client = new AcsClient(null, managerLoc, "ArchiveClient");
                    client.informACScomponents();
                    System.out.println("Archive/ACS component informed.");
                }
                catch (Exception e) {
                    System.out.println("ACS not running or not available. No Archive components informed about test area been cleaned.");
                }
                finally {
                    if (client != null) {
                        try {
                            client.tearDown();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            } else {
                System.out.println("Archive SchemaLoader: Running in standalone mode.");
            }
        }
    }

    private static void displayHelp() {
        System.out.println("Usage: archiveQuery [-i] [-h] [-q XPathQuery schemaName [-w fileName]] [-r UID] [-x UID]");
        System.out.println("Command line options are mutual exclusive.");
        System.out.println("  -i (INFO):     displays information about database backend.");
        System.out.println("  -h (HELP):     displays this text.");
        System.out.println("  -c (CLEAN) cleans test area.");
        System.out.println("  -q (QUERY):    queries the Archive with an XPath query and a schema name. If -w is given, paste full files into specified file. If the XPath query contains blanks, it must be enclosed in { and }, see example below.");
        System.out.println("  -r (RETRIEVE): retrieves the xml content of a document from the Archive");
        System.out.println("  -d (DATA-RETRIEVE): retrieves all of the data associated with a particular UID");
        System.out.println("  -x (XML-RETRIEVE): retrieves XML document for UID");
        System.out.println("EXAMPLE: archiveQuery -q {\\\"/ObsProject[./ProjectName=\"OPT - 6 bright polar stars\"][./pI=\"1 bright investigator\"]\\\"} ObsProject");
    }

    private static class AcsClient
    extends ComponentClient {
        private String connTypeName = "IDL:alma/xmlstore/ArchiveConnection:1.0";

        public AcsClient(Logger logger, String managerLoc, String clientName) throws Exception {
            super(logger, managerLoc, clientName);
        }

        public void informACScomponents() {
        }
    }
}

