/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers;

import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class DatabaseHelper {
    public static Pattern basicUidPattern = Pattern.compile("^[uU][iI][dD]://[0-9a-zA-Z]+(/[xX][0-9a-fA-F]+){2}(#\\w{1,}){0,}$");
    public static Pattern restrictedUidPattern = Pattern.compile("^[uU][iI][dD]://[0-9a-zA-Z]+(/[xX][0-9a-fA-F]+){2}$");

    @Deprecated
    public static boolean checkAccessPermissions(String user, String permissions, String docOwner) {
        return true;
    }

    public static boolean checkArchiveIdStoragePermission(URI uid, IdentifierManager imanager) throws DatabaseException, MalformedURIException {
        Matcher m = restrictedUidPattern.matcher(uid.toString());
        if (!m.matches()) {
            throw new MalformedURIException("The UID is not wellformed: " + uid.toString());
        }
        String archiveId = "DUMMY";
        try {
            archiveId = imanager.getArchiveId();
        }
        catch (Exception e) {
            throw new DatabaseException("Could not retrieve ArchiveId. " + e.toString());
        }
        if (!archiveId.startsWith("X0")) {
            return !uid.toString().startsWith("uid://X0");
        }
        return true;
    }

    public static String readFile(String fileLocation) throws IOException {
        StringBuffer content = new StringBuffer("");
        try (FileReader fr = null;){
            fr = new FileReader(fileLocation);
            while (fr.ready()) {
                content.append((char)fr.read());
            }
        }
        return content.toString();
    }

    public static String addAsLastChild(String xml, String newChild) throws DatabaseException, MalformedXMLException {
        Document doc;
        SAXBuilder parser = new SAXBuilder();
        try {
            doc = parser.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            throw new DatabaseException("Could not parse original stored XML document.");
        }
        catch (IOException e) {
            throw new DatabaseException("Something completely wrong here: " + e.toString());
        }
        Element root = doc.getRootElement();
        Element child = null;
        try {
            child = parser.build((Reader)new StringReader(newChild)).getRootElement();
        }
        catch (JDOMException e) {
            throw new MalformedXMLException("Could not parse new child element.");
        }
        catch (IOException e) {
            throw new DatabaseException("Something completely wrong here: " + e.toString());
        }
        root.addContent(child.detach());
        return new XMLOutputter().outputString(doc);
    }

    public static String traceToString(Throwable e) {
        StringWriter sWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(sWriter));
        return sWriter.toString();
    }
}

