/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.entitybuilder.ant;

import alma.tools.entitybuilder.CastorBuilder;
import alma.tools.entitybuilder.ant.XsdIncludeDir;
import alma.tools.entitybuilder.ant.XsdIncludedConfigFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class EntityBuilderTask
extends Task {
    private String javaOutputDir;
    private File xsdBindConfigFile;
    private List<XsdIncludedConfigFile> xsdIncludedConfigFileList = new ArrayList<XsdIncludedConfigFile>();
    private List<XsdIncludeDir> xsdIncludeDirList = new ArrayList<XsdIncludeDir>();
    private boolean verbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.verbose) {
            this.log("EntityBuilderTask.execute called");
        }
        Properties oldProps = (Properties)System.getProperties().clone();
        try {
            String[] mainArgs = new String[2 + this.xsdIncludeDirList.size()];
            mainArgs[0] = this.xsdBindConfigFile.getAbsolutePath();
            mainArgs[1] = this.javaOutputDir;
            for (int x = 0; x < this.xsdIncludeDirList.size(); ++x) {
                mainArgs[2 + x] = "-I" + this.xsdIncludeDirList.get(x).getDir().getAbsolutePath();
            }
            Object xsdBindConfIncluded = "";
            for (int x = 0; x < this.xsdIncludedConfigFileList.size(); ++x) {
                xsdBindConfIncluded = (String)xsdBindConfIncluded + this.xsdIncludedConfigFileList.get(x).getFilename() + " ";
            }
            System.setProperty("ACS.schemaconfigfiles", (String)xsdBindConfIncluded);
            CastorBuilder.main(mainArgs);
        }
        finally {
            System.setProperties(oldProps);
        }
    }

    public void setXsdBindConfigFile(File xsdBindConfigFile) {
        this.xsdBindConfigFile = xsdBindConfigFile;
        if (this.verbose) {
            this.log("set xsdBindConfigFile to " + xsdBindConfigFile.getAbsolutePath());
        }
    }

    public void setJavaOutputDir(String javaOutputDir) {
        this.javaOutputDir = javaOutputDir;
        if (this.verbose) {
            this.log("set javaOutputDir to " + javaOutputDir);
        }
    }

    public void addConfiguredXsdIncludedConfigFile(XsdIncludedConfigFile xsdIncludedConfigFile) {
        this.xsdIncludedConfigFileList.add(xsdIncludedConfigFile);
        if (this.verbose) {
            this.log("added xsdIncludedConfigFile " + xsdIncludedConfigFile.getFilename());
        }
    }

    public void addConfiguredXsdIncludeDir(XsdIncludeDir newXsdIncludeDir) {
        if (newXsdIncludeDir.isValid()) {
            this.xsdIncludeDirList.add(newXsdIncludeDir);
            if (this.verbose) {
                this.log("added XsdIncludeDir " + newXsdIncludeDir.getDir().getAbsolutePath());
            }
        } else if (this.verbose) {
            this.log("ignored invalid XsdIncludeDir " + newXsdIncludeDir.getDir().getAbsolutePath());
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

