/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.TypeDao;
import alma.sourcecat.model.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public final class TypeDaoImpl
implements TypeDao {
    private static final Log LOG = LogFactory.getLog(TypeDaoImpl.class);
    final Map<Integer, Collection<Integer>> idTypes = new HashMap<Integer, Collection<Integer>>();
    private static final int FETCH_SIZE = 10000;
    private static final String LIST_SQL = "SELECT type_id, type_name FROM types ORDER BY type_name";
    private static final String NEW_SQL = "SELECT type_id_seq.nextval FROM dual";
    private static final String INSERT_SQL = "INSERT INTO types     (type_id, type_name) VALUES (?, ?)";
    private static final String DELETE_SQL = "DELETE FROM types WHERE type_id = ?";
    private JdbcTemplate jdbcTmpl;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTmpl = new JdbcTemplate(dataSource);
        this.jdbcTmpl.setFetchSize(10000);
        this.cacheAllTypes();
    }

    @Override
    public Integer addType(String name) {
        int typeId = (Integer)this.jdbcTmpl.queryForObject(NEW_SQL, Integer.class);
        int res = 0;
        try {
            res = this.jdbcTmpl.update(INSERT_SQL, new Object[]{typeId, name});
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, (Throwable)e);
            res = 0;
        }
        return res == 1 ? typeId : 0;
    }

    @Override
    public Boolean removeType(Integer typeId) {
        boolean success = false;
        if (typeId != null) {
            try {
                success = this.jdbcTmpl.update(DELETE_SQL, new Object[]{typeId}) == 1;
            }
            catch (DataAccessException e) {
                LOG.error((Object)e, (Throwable)e);
                success = false;
            }
        }
        return success;
    }

    @Override
    public Boolean addSourceType(Integer sourceId, Integer typeId) {
        String addSourceTypeSql = "INSERT INTO source_type (source_id, type_id) VALUES (?, ?)";
        boolean success = false;
        if (sourceId != null && typeId != null) {
            try {
                if (this.jdbcTmpl.update("INSERT INTO source_type (source_id, type_id) VALUES (?, ?)", new Object[]{sourceId, typeId}) == 1) {
                    success = true;
                    Collection<Integer> eistingTypes = this.idTypes.get(sourceId);
                    if (eistingTypes == null) {
                        eistingTypes = new ArrayList<Integer>();
                        this.idTypes.put(sourceId, eistingTypes);
                    }
                    eistingTypes.add(typeId);
                }
            }
            catch (DataAccessException e) {
                LOG.error((Object)String.format("Could not add type %d to source %d.", sourceId, typeId), (Throwable)e);
            }
        }
        return success;
    }

    @Override
    public List<Type> listTypes() {
        return this.jdbcTmpl.query(LIST_SQL, (RowMapper)new RowMapper<Type>(){

            public Type mapRow(ResultSet result, int rowNum) throws SQLException {
                return new Type(result.getInt("type_id"), result.getString("type_name"));
            }
        });
    }

    @Override
    public Map<Integer, List<Integer>> getTypes(Set<Integer> typeIds) {
        final HashMap<Integer, List<Integer>> types = new HashMap<Integer, List<Integer>>();
        ArrayList<Integer> ids = new ArrayList<Integer>(typeIds);
        for (int i = 0; i < ids.size(); i += 1000) {
            List subList = ids.subList(i, Math.min(i + 1000, ids.size()));
            String sql = "select source_id, type_id from source_type where source_id in " + subList.toString().replace('[', '(').replace(']', ')');
            this.jdbcTmpl.query(sql, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    Integer sourceId = rs.getInt("source_id");
                    ArrayList<Integer> eistingTypes = (ArrayList<Integer>)types.get(sourceId);
                    if (eistingTypes == null) {
                        eistingTypes = new ArrayList<Integer>();
                        types.put(sourceId, eistingTypes);
                    }
                    eistingTypes.add(rs.getInt("type_id"));
                }
            });
        }
        return types;
    }

    private void cacheAllTypes() {
        String sql = "select source_id, type_id from source_type";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> cacheAllTypes");
        }
        long startTime = System.currentTimeMillis();
        final AtomicInteger count = new AtomicInteger(0);
        this.jdbcTmpl.query("select source_id, type_id from source_type", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Integer sourceId = rs.getInt("source_id");
                Integer typeId = rs.getInt("type_id");
                Collection<Integer> typesForId = TypeDaoImpl.this.idTypes.get(sourceId);
                if (typesForId == null) {
                    typesForId = new ArrayList<Integer>();
                    TypeDaoImpl.this.idTypes.put(sourceId, typesForId);
                }
                typesForId.add(typeId);
                count.incrementAndGet();
            }
        });
        LOG.info((Object)("loaded " + this.idTypes.size() + " source types in " + (System.currentTimeMillis() - startTime) + "ms"));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cached " + count.intValue()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- cacheAllTypes");
        }
    }

    @Override
    public Collection<Integer> getTypesOfSource(Integer sourceId) {
        return this.idTypes.get(sourceId);
    }
}

