/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import uk.ac.starlink.util.DataSource;

public class FileDataSource
extends DataSource {
    private File file;

    public FileDataSource(File file, String position) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("No such file " + file);
        }
        if (!file.canRead()) {
            throw new IOException("No read permission on file " + file);
        }
        if (file.isDirectory()) {
            throw new IOException(file + " is a directory");
        }
        this.file = file;
        this.setName(file.toString() + (position != null ? '#' + position : ""));
        this.setPosition(position);
    }

    public FileDataSource(File file) throws IOException {
        this(file, null);
    }

    public FileDataSource(String filename) throws IOException {
        this(new File(filename));
    }

    protected InputStream getRawInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public long getRawLength() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    public URL getURL() {
        URI withfrag;
        URI baseURI = this.file.toURI();
        try {
            withfrag = new URI(baseURI.getScheme(), baseURI.getSchemeSpecificPart(), this.getPosition());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)("What's wrong with URI " + baseURI.getScheme() + ':' + baseURI.getSchemeSpecificPart() + '#' + this.getPosition() + " ?"));
        }
        try {
            return withfrag.toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)("What's wrong with URL " + withfrag + " ?"));
        }
    }
}

