/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import uk.ac.starlink.util.DataSource;

public class ResourceDataSource
extends DataSource {
    private String resource;
    private ClassLoader classLoader = this.getClass().getClassLoader();

    public ResourceDataSource(String resource, int introLimit) {
        super(introLimit);
        this.resource = resource;
        this.setName(resource.substring(resource.lastIndexOf(47) + 1));
    }

    public ResourceDataSource(String resource) {
        this(resource, 512);
    }

    public InputStream getRawInputStream() throws IOException {
        InputStream istrm = this.getClassLoader().getResourceAsStream(this.resource);
        if (istrm == null) {
            throw new FileNotFoundException("No such resource " + this.resource);
        }
        return istrm;
    }

    public URL getURL() {
        return this.getClassLoader().getResource(this.resource);
    }

    public boolean exists() {
        return this.getClassLoader().getResource(this.resource) != null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

