/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers;

import alma.archive.database.helpers.DBConfiguration;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.MissingPropertiesException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class ArchiveConfiguration
extends DBConfiguration {
    private static Log LOG;
    private static ArchiveConfiguration instance;
    public static String defaultConfigFileName;
    public boolean storeInNgas = false;
    public String ngasBufferDir;
    public String ngasClientParams;
    private Properties props = new Properties();

    public static synchronized ArchiveConfiguration instance(Log logger) throws DatabaseException {
        if (logger == null) {
            logger = LogFactory.getLog((String)"Anonymous");
        }
        if (instance == null) {
            LOG = logger;
            String configFileLocation = System.getProperty("archive.configFile");
            String acsDataLocation = System.getProperty("ACS.data");
            if (configFileLocation != null && !configFileLocation.trim().isEmpty() || acsDataLocation != null && new File(new File(acsDataLocation, "config"), defaultConfigFileName).exists()) {
                instance = new ArchiveConfiguration(Logger.getLogger(ArchiveConfiguration.class.getSimpleName()));
            } else {
                throw new MissingPropertiesException("dbConfig.properties was deprecated and is now no longer supported. Please use archiveConfig.properties instead, specifying either -Darchive.configFile or -DACS.data.");
            }
        }
        return instance;
    }

    public static synchronized ArchiveConfiguration instance(Logger logger) throws DatabaseException {
        return ArchiveConfiguration.instance(LogFactory.getLog((String)logger.toString()));
    }

    protected ArchiveConfiguration(Logger logger) throws DatabaseException {
        logger.info("Constructing Archive configuration file as instance of ArchiveConfiguration.");
        this.reinit(logger);
        Object tnsDir = this.get("archive.db.tnsFileDirectory");
        if ((null == tnsDir || ((String)tnsDir).equals("")) && !this.get("archive.db.connection").startsWith("xmldb")) {
            String oraHome = System.getenv("ORACLE_HOME");
            if (oraHome != null && !oraHome.equals("")) {
                tnsDir = oraHome + "/network/admin";
            } else {
                throw new DatabaseException("archiveConfig.properties does not contain value for archive.db.tnsFileDirectory and $ORACLE_HOME not defined. Cannot read tnsnames.ora, aborting...");
            }
        }
        if (!this.get("archive.db.connection").startsWith("xmldb")) {
            logger.info("Using this tnsnames.ora for DB connection: " + (String)tnsDir + ". Setting system property oracle.net.tns_admin accordingly.");
            System.setProperty("oracle.net.tns_admin", (String)tnsDir);
        }
    }

    @Override
    public void reinit(Logger logger) throws DatabaseException {
        try {
            this.props = new Properties();
            this.dbBackend = null;
            this.readConfig(logger);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Problems while reading " + defaultConfigFileName, e);
        }
        this.createConfig(logger);
        logger.info(this.toString());
    }

    private void readConfig(Logger logger) throws IOException {
        this.props = new Properties();
        this.fileLocation = System.getProperty("archive.configFile");
        if (this.fileLocation != null && !this.fileLocation.equals("")) {
            logger.info("----------- Loading archive configuration from: " + this.fileLocation);
            FileInputStream propIn = new FileInputStream(this.fileLocation);
            this.props = this.readProps(propIn);
            ((InputStream)propIn).close();
        } else {
            Object acsdata = System.getProperty("ACS.data");
            if (acsdata != null) {
                acsdata = (String)acsdata + "/config/";
                try {
                    FileInputStream propIn = new FileInputStream((String)acsdata + defaultConfigFileName);
                    this.fileLocation = (String)acsdata + defaultConfigFileName;
                    logger.info("----------- Loading " + defaultConfigFileName + " from " + (String)acsdata);
                    this.props = this.readProps(propIn);
                    ((InputStream)propIn).close();
                }
                catch (FileNotFoundException e) {
                    logger.severe("No properties file " + defaultConfigFileName + " found in: " + (String)acsdata + "! Bailing out...");
                    throw new IOException("No archiveConfig.properties file found!");
                }
            } else {
                throw new IOException("$ACSDATA/ACS.data not defined, cannot read database configuration file.");
            }
        }
    }

    private Properties readProps(InputStream propIn) throws IOException {
        Properties props = new Properties();
        props.load(propIn);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = props.getProperty(key);
            val = ArchiveConfiguration.expand(val);
            props.setProperty(key, val);
        }
        return props;
    }

    static String expand(String s) {
        int markerPos = ((String)(s = ((String)s).trim())).indexOf("${");
        if (markerPos == -1) {
            return s;
        }
        int markerEnd = ((String)s).indexOf("}", markerPos);
        if (markerEnd == -1) {
            return s;
        }
        String preVarName = ((String)s).substring(0, markerPos);
        String embeddedVarName = ((String)s).substring(markerPos + 2, markerEnd);
        String postVarName = ((String)s).substring(markerEnd + 1);
        String embeddedVarValue = System.getProperty(embeddedVarName, "");
        s = preVarName + embeddedVarValue + postVarName;
        return ArchiveConfiguration.expand((String)s);
    }

    private void createConfig(Logger logger) throws DatabaseException {
        this.configParams = new HashMap();
        Enumeration<Object> e = this.props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("archive.") || key.startsWith("obops.")) {
                this.configParams.put(key, (String)this.props.get(key));
                logger.finest("Stored config param: " + key + "=" + (String)this.configParams.get(key));
                continue;
            }
            logger.finest("Ignored system property: " + key + "=" + (String)this.configParams.get(key));
        }
        logger.info("Verifying properties in archiveConfig.properties.");
        String dbConnection = this.get("archive.db.connection");
        if (dbConnection == null) {
            logger.severe("Property archive.db.connection undefined! Check archiveConfig.properties.");
            throw new DatabaseException("No Database backend specified (property archive.db.connection undefined).");
        }
        if (dbConnection.startsWith("xmldb:")) {
            this.dbBackend = "xmldb";
            this.configParams.put("archive.xmldb.location", dbConnection);
            this.configParams.put("archive.xmldb.cache", "100");
            this.configParams.put("archive.xmldb.name", "db");
            this.configParams.put("archive.xmldb.driver", "org.exist.xmldb.DatabaseImpl");
        } else if (dbConnection.toLowerCase().contains("oracle")) {
            this.dbBackend = "oracle";
        }
        if (this.dbBackend == null) {
            logger.severe("db.backend undefined! Check archiveConfig.properties: archive.db.connection is not properly defined.");
            throw new DatabaseException("Property archive.db.connection not properly defined.");
        }
        if ("operational".equals(this.get("archive.db.mode"))) {
            this.testMode = false;
            if (this.dbBackend.equals("xmldb")) {
                logger.severe("When running in operational mode, Oracle must be used. Check archiveConfig file.");
                throw new DatabaseException("Only Oracle DB can be used in operational mode");
            }
            if (this.get("archive.oracle.user").equals("almatest")) {
                logger.severe("When running in operational mode, user almatest is not allowed. Check archiveConfig file.");
                throw new DatabaseException("Permission denied: user almatest can not be used in operational mode");
            }
            if (this.get("archive.statearchive.user") != null && !"".equals(this.get("archive.statearchive.user")) || this.get("archive.statearchive.passwd") != null && !"".equals(this.get("archive.statearchive.passwd")) || this.get("archive.statearchive.connection") != null && !"".equals(this.get("archive.statearchive.connection"))) {
                logger.severe("When running in operational mode, specification of archive.statearchive.* is not allowed (they will be set internally). Check archiveConfig file.");
                throw new DatabaseException("When running in operational mode, specification of archive.statearchive.* is not allowed (they will be set internally). Check archiveConfig file.");
            }
            this.configParams.put("archive.statearchive.user", this.get("archive.oracle.user"));
            this.configParams.put("archive.statearchive.passwd", this.get("archive.oracle.passwd"));
            this.configParams.put("archive.statearchive.connection", this.get("archive.db.connection"));
        } else {
            this.testMode = true;
        }
        if (this.get("archive.ngast.interface") == null) {
            logger.severe("Property archive.ngast.interface undefined, but must be either ngamsArchiveClient cmd or test:...! Check archiveConfig.properties.");
            throw new DatabaseException("No NGAS interface specified.");
        }
        if (this.get("archive.ngast.interface").indexOf("ngamsArchiveClient") < 0) {
            if (!this.get("archive.ngast.interface").startsWith("test:")) {
                logger.severe("Property archive.ngast.interface must specify ngamsArchiveClient cmd or test:...! Check archiveConfig.properties.");
                throw new DatabaseException("No ngamsArchiveClient or test mode specified.");
            }
            this.configParams.put("archive.ngast.storeInNgast", "False");
            this.configParams.put("archive.ngast.testDir", this.get("archive.ngast.interface").substring(5, this.get("archive.ngast.interface").length()));
        } else {
            if (this.get("archive.ngast.storeInNgast") == null) {
                this.configParams.put("archive.ngast.storeInNgast", "Delayed");
            }
            if (this.get("archive.ngast.servers") != null) {
                if (this.get("archive.ngast.servers").indexOf(58) < 1) {
                    throw new DatabaseException("The value of archive.ngast.servers must be a comma-separated list of server:port pairs. Please check archiveConfig.properties.");
                }
                this.ngasBufferDir = this.get("archive.ngast.bufferDir");
                if (this.ngasBufferDir == null) {
                    logger.severe("NGAS archiving requested but archive.ngast.bufferDir undefined! Check archiveConfig.properties.");
                    throw new DatabaseException("No NGAS buffer directory specified in archive configuration.");
                }
            } else {
                logger.severe("Operational mode but archive.ngast.servers undefined! Check archiveConfig.properties.");
                throw new DatabaseException("No NGAS servers specified in operational archive configuration.");
            }
            this.configParams.put("archive.ngast.testDir", this.ngasBufferDir + "/NGAMS_ARCHIVE_CLIENT/queue");
            if (this.get("archive.ngast.interface").indexOf("-host") >= 0 || this.get("archive.ngast.interface").indexOf("-rootDir") >= 0 || this.get("archive.ngast.interface").indexOf("-port") >= 0 || this.get("archive.ngast.interface").indexOf("-servers") >= 0) {
                logger.severe("host, port, rootDir or servers MUST not be specified in archive.ngast.interface property. Please check archiveConfig.properties.");
                throw new DatabaseException("Inconsistency in archiveConfig.properties: host, port, rootDir or servers overspecified in archive.ngast.interface.");
            }
            this.configParams.put("archive.ngast.clientParams", this.get("archive.ngast.interface") + " -servers " + this.get("archive.ngast.servers") + " -rootDir " + this.ngasBufferDir);
            if (this.get("archive.bulkreceiver.schema") == null) {
                logger.severe("Operational mode but bulkreceiver.schema not configured! Check archiveConfig file.");
                throw new DatabaseException("bulkreceiver.schema not configured for operational mode.");
            }
            if (this.get("archive.bulkreceiver.DataBufferMax") == null) {
                logger.severe("Operational mode but bulkreceiver.DataBufferMax not configured! Check archiveConfig file.");
                throw new DatabaseException("bulkreceiver.DataBufferMax not configured for operational mode.");
            }
            if (this.get("archive.bulkreceiver.BufferThreadNumber") == null) {
                logger.severe("Operational mode but bulkreceiver.BufferThreadNumber not configured! Check archiveConfig file.");
                throw new DatabaseException("bulkreceiver.BufferThreadNumber not configured for operational mode.");
            }
            if (this.get("archive.bulkreceiver.FetchThreadRetry") == null) {
                logger.severe("Operational mode but bulkreceiver.FetchThreadRetry not configured! Check archiveConfig file.");
                throw new DatabaseException("bulkreceiver.FetchThreadRetry not configured for operational mode.");
            }
            if (this.get("archive.bulkreceiver.FetchThreadRetrySleep") == null) {
                logger.severe("Operational mode but bulkreceiver.FetchThreadRetrySleep not configured! Check archiveConfig file.");
                throw new DatabaseException("bulkreceiver.FetchThreadRetrySleep not configured for operational mode.");
            }
        }
        if (this.testMode && "oracle".equals(this.dbBackend) && !this.get("archive.oracle.user").equals("almatest") && !"alma_ut".equals(this.get("archive.oracle.user"))) {
            logger.severe("When running in test mode, user must be almatest or alma_ut. Check archiveConfig file.");
            throw new DatabaseException("Permission denied: only user almatest can run test mode");
        }
    }

    @Override
    public String toString() {
        StringBuffer out = new StringBuffer("Archive configuration: \n");
        Vector mykeys = new Vector(this.configParams.keySet());
        Collections.sort(mykeys);
        for (String name : mykeys) {
            if (name.endsWith("password") || name.endsWith("passwd")) {
                out.append("   - " + name + "= [HIDDEN]\n");
                continue;
            }
            out.append("   - " + name + "=" + (String)this.configParams.get(name) + "\n");
        }
        return out.toString();
    }

    @Override
    public Element toElement() {
        Element root = new Element("archiveconfiguration");
        Iterator iter = this.configParams.keySet().iterator();
        while (iter.hasNext()) {
            Element config = new Element("config");
            String name = (String)iter.next();
            config.setAttribute("name", name);
            config.setAttribute("value", (String)this.configParams.get(name));
            root.addContent((Content)config);
        }
        return root;
    }

    @Override
    public String toXmlString() {
        Element element = this.toElement();
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        String xml = out.outputString(element);
        return xml;
    }

    @Override
    public String get(String paramName) {
        return (String)this.configParams.get(paramName);
    }

    @Override
    public String getConnectionURL(String propertyName) {
        return "jdbc:oracle:thin:@" + this.get(propertyName);
    }

    public List<InetSocketAddress> getNasgServers() throws DatabaseException {
        String server = this.get("archive.ngast.servers");
        if (server == null || server.trim().isEmpty()) {
            throw new DatabaseException("Property archive.ngast.servers not defined in archiveConfig.properties");
        }
        String[] servers = server.split(",");
        ArrayList<InetSocketAddress> serverList = new ArrayList<InetSocketAddress>();
        for (String nextServer : servers) {
            String[] addressParts = nextServer.split(":");
            String serverName = addressParts[0];
            String port = addressParts[1];
            LOG.info((Object)("NGAMS mode: using server " + serverName + ":" + port));
            serverList.add(new InetSocketAddress(serverName, Integer.parseInt(port)));
        }
        return serverList;
    }

    public boolean storeInNgas() {
        return "true".equalsIgnoreCase(this.get("archive.ngast.storeInNgast")) || "delayed".equalsIgnoreCase(this.get("archive.ngast.storeInNgast"));
    }

    static {
        defaultConfigFileName = "archiveConfig.properties";
    }
}

