/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.ACSPorts;
import alma.cdbErrType.CDBXMLErrorEx;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import com.cosylab.CDB.WDAL;
import com.cosylab.CDB.WDALHelper;
import com.cosylab.cdb.jdal.XMLHandler;
import com.cosylab.cdb.jdal.XMLTreeNode;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CDBDefault {
    static String strIOR;
    static String curl;
    static String curl_allComponents;
    static ORB orb;
    private static Logger m_logger;

    public static void main(String[] args) {
        try {
            strIOR = null;
            if (args.length < 2) {
                System.out.println("Usage: cmd <idl_type> <instance_name> [-d ior -h]");
                return;
            }
            m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("CDBDefault", true);
            String in_type = args[0];
            String in_name = args[1];
            curl_allComponents = "MACI/Components";
            curl = curl_allComponents + "/" + in_name;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-d") && i < args.length - 1) {
                    strIOR = args[++i];
                }
                if (!args[i].equals("-h")) continue;
                System.out.println("Usage: cmd idl_type instance_name [-d ior -h]");
                return;
            }
            if (strIOR == null) {
                strIOR = "corbaloc::" + InetAddress.getLocalHost().getHostName() + ":" + ACSPorts.getCDBPort() + "/CDB";
            }
            orb = ORB.init((String[])new String[0], null);
            WDAL wdal = WDALHelper.narrow((Object)orb.string_to_object(strIOR));
            String xml = wdal.get_DAO(curl_allComponents);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLHandler xmlSolver = new XMLHandler(false, m_logger);
            saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)xmlSolver);
            if (xmlSolver.m_errorString != null) {
                String info = "XML parser error: " + xmlSolver.m_errorString;
                AcsJCDBXMLErrorEx cdbxmlErr = new AcsJCDBXMLErrorEx();
                throw cdbxmlErr;
            }
            CDBDefault.setDefault(xmlSolver.m_rootNode, in_type, in_name);
        }
        catch (AcsJCDBXMLErrorEx e) {
            m_logger.log((Level)AcsLogLevel.NOTICE, "Xml Error", e);
            e.printStackTrace();
        }
        catch (Exception e) {
            m_logger.log((Level)AcsLogLevel.NOTICE, "Error", e);
            e.printStackTrace();
        }
    }

    public static void setDefault(XMLTreeNode node_root, String in_type, String in_name) {
        try {
            Iterator<String> nodesIter = node_root.getNodesMap().keySet().iterator();
            WDAL wdal = WDALHelper.narrow((Object)orb.string_to_object(strIOR));
            while (nodesIter.hasNext()) {
                String key = nodesIter.next();
                XMLTreeNode node = node_root.getNodesMap().get(key);
                String name = node.getFieldMap().get("Name");
                String type = node.getFieldMap().get("Type");
                String isDefault = node.getFieldMap().get("Default");
                String strTrue = "true";
                if (in_type.equals(type)) {
                    if (strTrue.equals(isDefault)) {
                        if (in_name.equals(name)) {
                            return;
                        }
                        try {
                            wdao = wdal.get_WDAO_Servant(curl_allComponents);
                            wdao.set_string(name + "/Default", "false");
                        }
                        catch (Exception e) {
                            wdao = wdal.get_WDAO_Servant(curl_allComponents + "/" + name);
                            wdao.set_string("Default", "false");
                        }
                    } else if (in_name.equals(name)) {
                        try {
                            wdao = wdal.get_WDAO_Servant(curl_allComponents);
                            wdao.set_string(name + "/Default", "true");
                        }
                        catch (Exception e) {
                            wdao = wdal.get_WDAO_Servant(curl);
                            wdao.set_string("Default", "true");
                        }
                    }
                }
                XMLTreeNode value = node_root.getNodesMap().get(key);
                CDBDefault.setDefault(value, in_type, in_name);
            }
        }
        catch (CDBXMLErrorEx e) {
            m_logger.log((Level)AcsLogLevel.NOTICE, "Xml Error", e);
            e.printStackTrace();
        }
        catch (Exception e) {
            m_logger.log((Level)AcsLogLevel.NOTICE, "Error", e);
            e.printStackTrace();
        }
    }
}

