/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasLayer;
import diva.canvas.CanvasPane;
import diva.canvas.CanvasUtilities;
import diva.canvas.DamageRegion;
import diva.canvas.GraphicsPane;
import diva.canvas.event.LayerEvent;
import diva.util.java2d.ShapeUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;

public class JCanvas
extends JComponent
implements Printable {
    private BufferedImage _offscreen = null;
    private CanvasPane _canvasPane = null;
    private DefaultBoundedRangeModel _horizontalRangeModel = new DefaultBoundedRangeModel();
    private DefaultBoundedRangeModel _verticalRangeModel = new DefaultBoundedRangeModel();
    private transient boolean _workaroundClearRectBug = this._checkForClearRectBug();

    public JCanvas() {
        this(new GraphicsPane());
    }

    public JCanvas(CanvasPane pane) {
        this.setBackground(Color.white);
        this.setCanvasPane(pane);
        this.enableEvents(48L);
        super.setToolTipText("");
    }

    public final CanvasPane getCanvasPane() {
        return this._canvasPane;
    }

    public String getToolTipText(MouseEvent e) {
        LayerEvent layerevent = null;
        if (this._canvasPane == null) {
            return null;
        }
        layerevent = new LayerEvent(e);
        AffineTransform at = this._canvasPane.getTransformContext().getInverseTransform();
        layerevent.transform(at);
        String tip = this._canvasPane.getToolTipText(layerevent);
        return tip;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics g) {
        boolean paintAll;
        Rectangle clip = g.getClipBounds();
        Dimension d = this.getSize();
        if (clip == null) {
            clip = new Rectangle(0, 0, d.width, d.height);
        }
        boolean bl = paintAll = clip.x == 0 && clip.y == 0 && clip.width == d.width && clip.height == d.height;
        if (!this.isDoubleBuffered()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(this.getBackground());
            if (this._workaroundClearRectBug) {
                g2d.clearRect(0, 0, clip.width, clip.height);
            } else {
                g2d.clearRect(clip.x, clip.y, clip.width, clip.height);
            }
            if (paintAll) {
                this._canvasPane.paint(g2d);
            } else {
                this._canvasPane.paint(g2d, clip);
            }
        } else {
            if (this._offscreen == null || this._offscreen.getWidth() != clip.width || this._offscreen.getHeight() != clip.height) {
                this._offscreen = null;
                this._offscreen = new BufferedImage(clip.width, clip.height, 1);
            }
            Graphics2D g2d = this._offscreen.createGraphics();
            g2d.setBackground(this.getBackground());
            if (this._workaroundClearRectBug) {
                g2d.clearRect(0, 0, clip.width, clip.height);
            } else {
                g2d.clearRect(clip.x, clip.y, clip.width, clip.height);
            }
            if (paintAll) {
                this._canvasPane.paint(g2d);
            } else {
                g2d.translate(-clip.x, -clip.y);
                this._canvasPane.paint(g2d, clip);
            }
            g.drawImage(this._offscreen, clip.x, clip.y, null);
        }
        super.paint(g);
    }

    public int print(Graphics graphics, PageFormat format, int index) throws PrinterException {
        Dimension dimension = this.getSize();
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height);
        return this.print(graphics, format, index, bounds);
    }

    public int print(Graphics graphics, PageFormat format, int index, Rectangle2D printRegion) throws PrinterException {
        if (index >= 1) {
            return 1;
        }
        Rectangle2D.Double pageBounds = new Rectangle2D.Double(format.getImageableX(), format.getImageableY(), format.getImageableWidth(), format.getImageableHeight());
        ((Graphics2D)graphics).transform(CanvasUtilities.computeFitTransform(printRegion, pageBounds));
        graphics.setClip(printRegion);
        this.paint(graphics);
        return 0;
    }

    public void repaint(DamageRegion d) {
        d.apply(this);
    }

    public final void setCanvasPane(CanvasPane pane) {
        if (this._canvasPane != null) {
            this._canvasPane.setCanvas(null);
        }
        this._canvasPane = pane;
        if (pane != null) {
            pane.setCanvas(this);
        }
    }

    public void setDoubleBuffered(boolean flag) {
        super.setDoubleBuffered(flag);
        if (!this.isDoubleBuffered()) {
            this._offscreen = null;
        }
    }

    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        if (this._canvasPane != null) {
            Dimension size = this.getSize();
            Point2D.Double s = new Point2D.Double(size.width, size.height);
            this._canvasPane.setSize(s);
        }
    }

    public BoundedRangeModel getHorizontalRangeModel() {
        return this._horizontalRangeModel;
    }

    public BoundedRangeModel getVerticalRangeModel() {
        return this._verticalRangeModel;
    }

    public Rectangle2D getViewSize() {
        Rectangle2D viewRect = null;
        Iterator layers = this.getCanvasPane().layers();
        while (layers.hasNext()) {
            CanvasLayer layer = (CanvasLayer)layers.next();
            Rectangle2D rect = layer.getLayerBounds();
            if (rect.isEmpty()) continue;
            if (viewRect == null) {
                viewRect = rect;
                continue;
            }
            viewRect.add(rect);
        }
        if (viewRect == null) {
            return this.getVisibleSize();
        }
        return viewRect;
    }

    public Rectangle2D getVisibleSize() {
        AffineTransform inverse;
        AffineTransform current = this.getCanvasPane().getTransformContext().getTransform();
        try {
            inverse = current.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e.toString());
        }
        Dimension size = this.getSize();
        Rectangle2D.Double visibleRect = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
        return ShapeUtilities.transformBounds(visibleRect, inverse);
    }

    protected void processMouseEvent(MouseEvent e) {
        this.internalProcessMouseEvent(e);
        if (!e.isConsumed()) {
            super.processMouseEvent(e);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        this.internalProcessMouseEvent(e);
        if (!e.isConsumed()) {
            super.processMouseMotionEvent(e);
        }
    }

    private void internalProcessMouseEvent(MouseEvent e) {
        LayerEvent layerevent = null;
        if (this._canvasPane == null) {
            return;
        }
        layerevent = new LayerEvent(e);
        AffineTransform at = this._canvasPane.getTransformContext().getInverseTransform();
        layerevent.transform(at);
        this._canvasPane.dispatchEvent(layerevent);
    }

    private boolean _checkForClearRectBug() {
        return System.getProperty("java.version").equals("1.2beta4");
    }
}

