/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import diva.gui.AppContext;
import diva.gui.AppContextDelegate;
import diva.gui.MDIContext;
import diva.gui.ViewEvent;
import diva.gui.ViewListener;
import diva.gui.toolbox.JPseudoFrame;
import diva.gui.toolbox.JShadePane;
import diva.gui.toolbox.JStatusBar;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class DesktopContext
extends AppContextDelegate
implements MDIContext {
    private transient EventListenerList _listeners = new EventListenerList();
    private transient JDesktopPane _desktopPane;
    private transient JSplitPane _splitPane;
    private transient JComponent _palettePane;
    private transient JPanel _toolBarPane;
    private transient JStatusBar _statusBar;
    private transient JToolBar _toolBar;
    private transient FrameManager _frameManager;
    private transient JComponent _currentPane;
    private transient Icon _frameIcon;
    private transient JPseudoFrame _pseudoFrame;
    private transient int _layoutMode = 0;
    private transient boolean _maximizeMode = false;
    public static final int LAYOUT_PLACED = 0;
    public static final int LAYOUT_HORIZONTAL = 1;
    public static final int LAYOUT_VERTICAL = 2;
    public static final int LAYOUT_CASCADED = 3;
    private transient HashMap _frames = new HashMap();

    public DesktopContext(AppContext context) {
        this(context, new JShadePane());
    }

    public DesktopContext(AppContext context, JComponent palette) {
        super(context);
        this.setSize(800, 600);
        this.setJMenuBar(new JMenuBar());
        JPanel contentPane = (JPanel)this.getContentPane();
        this._toolBarPane = new JPanel();
        this._toolBar = new JToolBar();
        this._statusBar = new JStatusBar();
        this._desktopPane = new JDesktopPane();
        this._desktopPane.setBackground(contentPane.getBackground());
        this._palettePane = palette;
        this._splitPane = new JSplitPane();
        this._splitPane.setLeftComponent(this._palettePane);
        this._splitPane.setRightComponent(this._desktopPane);
        this._splitPane.setContinuousLayout(true);
        contentPane.add((Component)this._toolBarPane, "North");
        this._toolBarPane.add(this._toolBar);
        contentPane.add((Component)this._splitPane, "Center");
        contentPane.add((Component)this._statusBar, "South");
        this._pseudoFrame = new DesktopPseudoFrame(this._desktopPane, this.getJMenuBar());
        this._frameManager = new FrameManager();
        this._pseudoFrame.addActionListener(this._frameManager);
    }

    public void addContentPane(String title, JComponent pane) {
        DesktopInternalFrame iframe = new DesktopInternalFrame(title, true, true, true, true);
        Icon icon = this.getFrameIcon();
        if (icon != null) {
            iframe.setFrameIcon(icon);
        }
        this._frames.put(pane, iframe);
        iframe.setDefaultCloseOperation(0);
        iframe.getContentPane().add(pane);
        iframe.setBounds(10, 10, 300, 200);
        iframe.setVisible(true);
        iframe.addComponentListener(this._frameManager);
        iframe.addInternalFrameListener(this._frameManager);
        iframe.addPropertyChangeListener(this._frameManager);
        this._desktopPane.add(iframe);
        this.refreshLayout();
    }

    public void addViewListener(ViewListener listener) {
        this._listeners.add(ViewListener.class, listener);
    }

    public JComponent getCurrentContentPane() {
        return this._currentPane;
    }

    public Icon getFrameIcon() {
        return this._frameIcon;
    }

    public JInternalFrame getInternalFrame(JComponent pane) {
        return (JInternalFrame)this._frames.get(pane);
    }

    public int getLayoutMode() {
        return this._layoutMode;
    }

    public JComponent getPalettePane() {
        return this._palettePane;
    }

    public JStatusBar getStatusBar() {
        return this._statusBar;
    }

    public JSplitPane getSplitPane() {
        return this._splitPane;
    }

    public JToolBar getJToolBar() {
        return this._toolBar;
    }

    public JPanel getToolBarPane() {
        return this._toolBarPane;
    }

    public boolean isMaximizeMode() {
        return this._maximizeMode;
    }

    public void refreshLayout() {
        switch (this._layoutMode) {
            default: 
        }
    }

    public void removeContentPane(JComponent pane) {
        if (pane == this._currentPane) {
            this._pseudoFrame.hideFrame();
        }
        JInternalFrame iframe = (JInternalFrame)this._frames.remove(pane);
        try {
            iframe.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        iframe.dispose();
    }

    public void removeViewListener(ViewListener listener) {
        this._listeners.remove(ViewListener.class, listener);
    }

    public void setCurrentContentPane(JComponent pane) {
        JInternalFrame iframe = this.getInternalFrame(pane);
        if (this._maximizeMode) {
            if (pane != this._currentPane) {
                JInternalFrame currentFrame = this.getInternalFrame(this._currentPane);
                this._pseudoFrame.hideFrame();
                try {
                    iframe.setSelected(true);
                    this._pseudoFrame.showFrame(iframe);
                }
                catch (PropertyVetoException ex) {
                    this._pseudoFrame.showFrame(currentFrame);
                    return;
                }
            }
        } else {
            if (!iframe.isSelected()) {
                iframe.grabFocus();
                iframe.show();
            }
            this.refreshLayout();
        }
        this._currentPane = pane;
        pane.requestFocus();
    }

    public void setFrameIcon(Icon icon) {
        this._frameIcon = icon;
    }

    public void setLayoutMode(int mode) {
        this._layoutMode = mode;
        if (!this.isMaximizeMode()) {
            this.refreshLayout();
        }
    }

    public void setMaximizeMode(boolean mode) {
        if (mode == this._maximizeMode) {
            return;
        }
        JInternalFrame iframe = this.getInternalFrame(this._currentPane);
        if (mode) {
            this._pseudoFrame.showFrame(iframe);
        } else {
            this._pseudoFrame.hideFrame();
            this.refreshLayout();
        }
        this._maximizeMode = mode;
    }

    public void setPalettePane(JComponent pane) {
        this._palettePane = pane;
        this._splitPane.setLeftComponent(pane);
    }

    public void showStatus(String status) {
        this._statusBar.setMessage(status);
    }

    private class FrameManager
    extends InternalFrameAdapter
    implements ComponentListener,
    PropertyChangeListener,
    ActionListener {
        private FrameManager() {
        }

        public void actionPerformed(ActionEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
            this.fire(e, 4);
        }

        public void componentResized(ComponentEvent e) {
            this.fire(e, 5);
        }

        public void componentShown(ComponentEvent e) {
            this.fire(e, 7);
        }

        public void componentHidden(ComponentEvent e) {
            this.fire(e, 3);
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            this.fire(e, 6);
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            this.fire(e, 1);
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            this.fire(e, 0);
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            this.fire(e, 2);
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
            this.fire(e, 7);
        }

        public void internalFrameIconified(InternalFrameEvent e) {
            this.fire(e, 3);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if (property.equals("maximum") && ((Boolean)e.getNewValue()).booleanValue()) {
                DesktopContext.this.setMaximizeMode(true);
            }
        }

        private void fire(AWTEvent e, int id) {
            JComponent c;
            JInternalFrame f = (JInternalFrame)e.getSource();
            if (f.getContentPane().getComponentCount() == 1) {
                c = (JComponent)f.getContentPane().getComponent(0);
            } else if (f.getContentPane().getComponentCount() == 0 && DesktopContext.this.isMaximizeMode()) {
                c = DesktopContext.this.getCurrentContentPane();
            } else {
                throw new RuntimeException("Could not find content for frame " + f);
            }
            ViewEvent event = new ViewEvent(c, id);
            Object[] listeners = DesktopContext.this._listeners.getListenerList();
            block10: for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ViewListener.class) continue;
                switch (id) {
                    case 1: {
                        ((ViewListener)listeners[i + 1]).viewClosed(event);
                        continue block10;
                    }
                    case 0: {
                        ((ViewListener)listeners[i + 1]).viewClosing(event);
                        continue block10;
                    }
                    case 2: {
                        ((ViewListener)listeners[i + 1]).viewDeselected(event);
                        continue block10;
                    }
                    case 3: {
                        ((ViewListener)listeners[i + 1]).viewHidden(event);
                        continue block10;
                    }
                    case 4: {
                        ((ViewListener)listeners[i + 1]).viewMoved(event);
                        continue block10;
                    }
                    case 5: {
                        ((ViewListener)listeners[i + 1]).viewResized(event);
                        continue block10;
                    }
                    case 6: {
                        ((ViewListener)listeners[i + 1]).viewSelected(event);
                        continue block10;
                    }
                    case 7: {
                        ((ViewListener)listeners[i + 1]).viewShown(event);
                    }
                }
            }
        }
    }

    private class DesktopPseudoFrame
    extends JPseudoFrame {
        public DesktopPseudoFrame(JDesktopPane desktopPane, JMenuBar menuBar) {
            super(desktopPane, menuBar);
        }

        protected void removeComponent(JComponent c) {
            DesktopContext.this._splitPane.setRightComponent(null);
        }

        protected void setComponent(JComponent c) {
            DesktopContext.this._splitPane.setRightComponent(c);
        }

        public void setClosed(boolean flag) throws PropertyVetoException {
            if (flag) {
                DesktopInternalFrame frame = (DesktopInternalFrame)DesktopContext.this.getInternalFrame(DesktopContext.this.getCurrentContentPane());
                frame.doDefaultCloseAction();
            }
        }

        public void setIcon(boolean flag) throws PropertyVetoException {
            if (flag) {
                JInternalFrame frame = DesktopContext.this.getInternalFrame(DesktopContext.this.getCurrentContentPane());
                DesktopContext.this.setMaximizeMode(false);
                frame.setIcon(true);
            }
        }

        public void setMaximum(boolean flag) throws PropertyVetoException {
            DesktopContext.this.setMaximizeMode(flag);
        }
    }

    private static class DesktopInternalFrame
    extends JInternalFrame {
        public DesktopInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
            super(title, resizable, closable, maximizable, iconifiable);
        }

        public void doDefaultCloseAction() {
            this.fireInternalFrameEvent(25550);
        }
    }
}

