/*
 * Decompiled with CFR 0.152.
 */
package diva.gui.toolbox;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.toolbox.ImageFigure;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class FigureIcon
extends ImageIcon {
    public FigureIcon(Figure figure) {
        this(figure, false);
    }

    public FigureIcon(Figure figure, boolean antialias) {
        if (figure instanceof ImageFigure) {
            ImageFigure imageFigure = (ImageFigure)figure;
            this.setImage(imageFigure.getImage());
        } else {
            Rectangle2D bounds = figure.getBounds();
            BufferedImage image = new BufferedImage((int)bounds.getWidth(), (int)bounds.getHeight(), 1);
            Graphics2D graphics = image.createGraphics();
            if (antialias) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            figure.paint(graphics);
            this.setImage(image);
        }
    }

    public FigureIcon(Figure figure, int x, int y) {
        this(figure, x, y, 0, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FigureIcon(Figure figure, int x, int y, int border, boolean antialias) {
        if (figure instanceof ImageFigure && border == 0) {
            ImageFigure imageFigure = (ImageFigure)figure;
            Image image = imageFigure.getImage();
            if (image == null) throw new NullPointerException("Failed to get an image from " + imageFigure);
            image = image.getScaledInstance(x, y, 1);
            this.setImage(image);
            return;
        } else {
            Rectangle2D bounds = figure.getBounds();
            Rectangle2D.Double size = new Rectangle2D.Double(border, border, x - 2 * border, y - 2 * border);
            AffineTransform transform = CanvasUtilities.computeFitTransform(bounds, size);
            figure.transform(transform);
            BufferedImage image = new BufferedImage(x, y, 6);
            Graphics2D graphics = image.createGraphics();
            if (antialias) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            graphics.setBackground(new Color(0, 0, 0, 0));
            graphics.clearRect(0, 0, x, y);
            figure.paint(graphics);
            this.setImage(image);
        }
    }
}

