/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.lang.reflect.Array;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import uk.ac.starlink.table.BooleanCellRenderer;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.NumericCellRenderer;
import uk.ac.starlink.table.gui.ValueInfoCellEditor;
import uk.ac.starlink.table.gui.ValueInfoCellRenderer;

public class DefaultValueInfo
implements ValueInfo {
    private String name;
    private String unitString = null;
    private String ucd = null;
    private String description = "";
    private Class contentClass = Object.class;
    private boolean isNullable = true;
    private int[] shape = new int[]{-1};
    private int elementSize = -1;
    private TableCellRenderer cellRenderer;
    private TableCellEditor cellEditor;
    private static Pattern trailDigits;
    private static Pattern trailSpaces;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultValueInfo() {
    }

    public DefaultValueInfo(String name) {
        this.name = name;
    }

    public DefaultValueInfo(String name, Class contentClass) {
        this(name);
        this.setContentClass(contentClass);
    }

    public DefaultValueInfo(String name, Class contentClass, String description) {
        this(name);
        this.setContentClass(contentClass);
        this.setDescription(description);
    }

    public DefaultValueInfo(ValueInfo base) {
        this(base.getName());
        this.setUnitString(base.getUnitString());
        this.setUCD(base.getUCD());
        this.setDescription(base.getDescription());
        this.setContentClass(base.getContentClass());
        this.setShape(base.getShape());
        this.setElementSize(base.getElementSize());
        this.setNullable(base.isNullable());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setUnitString(String unitString) {
        this.unitString = unitString;
    }

    public String getUnitString() {
        return this.unitString;
    }

    public void setUCD(String ucd) {
        this.ucd = ucd;
    }

    public String getUCD() {
        return this.ucd;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Class getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(Class contentClass) {
        if (contentClass.isPrimitive()) {
            throw new IllegalArgumentException("Primitive content class " + contentClass + " not permitted");
        }
        if (contentClass != this.contentClass) {
            this.cellRenderer = null;
            this.cellEditor = null;
        }
        this.contentClass = contentClass;
        if (!this.isArray()) {
            this.setShape(null);
        } else if (this.shape == null) {
            this.setShape(new int[]{-1});
        }
    }

    public boolean isArray() {
        return this.contentClass.isArray();
    }

    public int[] getShape() {
        return this.shape == null ? null : (int[])this.shape.clone();
    }

    public void setShape(int[] shape) {
        if (shape != null) {
            for (int i = 0; i < shape.length - 1; ++i) {
                if (shape[i] > 0) continue;
                throw new IllegalArgumentException("Bad shape");
            }
        }
        this.shape = shape;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public void setElementSize(int size) {
        this.elementSize = size;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public static ValueInfo generalise(ValueInfo vi1, ValueInfo vi2) {
        if (vi1.equals(vi2)) {
            return vi1;
        }
        DefaultValueInfo vi = new DefaultValueInfo(vi1);
        if (vi1.getUnitString() != null && !vi1.getUnitString().equals(vi2.getUnitString())) {
            vi.setUnitString(null);
        }
        if (vi1.getUCD() != null && !vi1.getUCD().equals(vi2.getUCD())) {
            vi.setUCD(null);
        }
        if (vi1.getDescription() != null && !vi1.getDescription().equals(vi2.getDescription())) {
            vi.setDescription("");
        }
        Class c2 = vi2.getContentClass();
        vi.setContentClass(Object.class);
        for (Class c1 = vi1.getContentClass(); c1 != null; c1 = c1.getSuperclass()) {
            if (!c1.isAssignableFrom(c2)) continue;
            vi.setContentClass(c1);
            break;
        }
        if (vi.isArray()) {
            int[] s1 = vi1.getShape();
            int[] s2 = vi2.getShape();
            if (s1 != null && s2 != null) {
                if (s1.length != s2.length) {
                    vi.setShape(new int[]{-1});
                } else {
                    int ndim = s1.length;
                    boolean same = true;
                    for (int i = 0; i < ndim - 1 && same; ++i) {
                        if (s1[i] == s2[i]) continue;
                        same = false;
                    }
                    if (same) {
                        if (ndim > 1 && s1[ndim - 1] != s2[ndim - 1]) {
                            s1[ndim - 1] = -1;
                        }
                        vi.setShape(s1);
                    } else {
                        vi.setShape(new int[]{-1});
                    }
                }
            }
        }
        if (vi1.isNullable() || vi2.isNullable()) {
            vi.setNullable(true);
        }
        return vi;
    }

    public TableCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            Class clazz;
            this.cellRenderer = Number.class.isAssignableFrom(clazz = this.getContentClass()) ? new NumericCellRenderer(clazz) : (clazz.equals(Boolean.class) ? BooleanCellRenderer.getInstance() : new ValueInfoCellRenderer(this));
        }
        return this.cellRenderer;
    }

    public TableCellEditor getCellEditor() {
        if (this.cellEditor == null) {
            Class clazz = this.getContentClass();
            this.cellEditor = ValueInfoCellEditor.makeEditor(this);
        }
        return this.cellEditor;
    }

    public String formatValue(Object value, int maxLength) {
        int over;
        Matcher tmatch;
        if (maxLength <= 0) {
            return "";
        }
        if (Tables.isBlank(value)) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (!this.isArray()) {
            buf.append(value == null ? "" : value.toString());
        } else {
            int[] ashape = DefaultValueInfo.getActualShape(this.shape, Array.getLength(value));
            DefaultValueInfo.appendElements(buf, value, 0, ashape, maxLength);
        }
        if (buf.length() > maxLength && (value instanceof Float || value instanceof Double) && (tmatch = trailDigits.matcher(buf)).find()) {
            over = buf.length() - maxLength;
            if (tmatch.group(1).length() > over) {
                buf.setLength(maxLength);
            }
        }
        if (buf.length() > maxLength && (tmatch = trailSpaces.matcher(buf)).lookingAt()) {
            over = buf.length() - maxLength;
            if (tmatch.group(1).length() > buf.length() - maxLength) {
                buf.setLength(maxLength);
            }
        }
        if (buf.length() > maxLength) {
            buf.setLength(Math.max(0, maxLength - 3));
            buf.append("...");
        }
        return buf.toString();
    }

    private static int appendElements(StringBuffer sb, Object array, int pos, int[] dims, int maxChars) {
        block7: {
            int leng = Array.getLength(array);
            int ndim = dims.length;
            int limit = dims[ndim - 1];
            if (sb.length() >= maxChars) break block7;
            sb.append('(');
            if (ndim == 1) {
                for (int i = 0; i < limit && sb.length() < maxChars; ++i) {
                    if (pos < leng) {
                        sb.append(Array.get(array, pos++));
                    }
                    if (i < limit - 1) {
                        sb.append(", ");
                        continue;
                    }
                    sb.append(")");
                }
            } else {
                int[] subdims = new int[ndim - 1];
                System.arraycopy(dims, 0, subdims, 0, ndim - 1);
                for (int i = 0; i < limit && sb.length() < maxChars; ++i) {
                    pos = DefaultValueInfo.appendElements(sb, array, pos, subdims, maxChars);
                    if (i < limit - 1) {
                        sb.append(", ");
                        continue;
                    }
                    sb.append(")");
                }
            }
        }
        return pos;
    }

    public static String formatClass(Class clazz) {
        String basename;
        int ndim;
        block20: {
            int pos;
            String cname;
            block19: {
                cname = clazz.getName();
                pos = -1;
                ndim = 0;
                while (cname.charAt(++pos) == '[') {
                    ++ndim;
                }
                if (cname.length() != pos + 1) break block19;
                switch (cname.charAt(pos)) {
                    case 'B': {
                        basename = "byte";
                        break block20;
                    }
                    case 'C': {
                        basename = "char";
                        break block20;
                    }
                    case 'D': {
                        basename = "double";
                        break block20;
                    }
                    case 'F': {
                        basename = "float";
                        break block20;
                    }
                    case 'I': {
                        basename = "int";
                        break block20;
                    }
                    case 'J': {
                        basename = "long";
                        break block20;
                    }
                    case 'S': {
                        basename = "short";
                        break block20;
                    }
                    case 'Z': {
                        basename = "boolean";
                        break block20;
                    }
                    case 'V': {
                        basename = "void";
                        break block20;
                    }
                    default: {
                        throw new AssertionError((Object)("What class is " + cname + "??"));
                    }
                }
            }
            if (ndim == 0) {
                basename = cname;
            } else {
                if (!$assertionsDisabled && cname.charAt(pos) != 'L') {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && cname.charAt(cname.length() - 1) != ';') {
                    throw new AssertionError();
                }
                basename = cname.substring(pos + 1, cname.length() - 1);
            }
        }
        basename = basename.replaceFirst("^java\\.lang\\.", "");
        if (basename.equals("java.net.URL")) {
            basename = "URL";
        }
        if (basename.equals("java.net.URI")) {
            basename = "URI";
        }
        StringBuffer buf = new StringBuffer(basename);
        for (int i = 0; i < ndim; ++i) {
            buf.append("[]");
        }
        return buf.toString();
    }

    public static String formatShape(int[] shape) {
        if (shape == null || shape.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < shape.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            if (shape[i] <= 0) {
                buf.append('*');
                continue;
            }
            buf.append(shape[i]);
        }
        return buf.toString();
    }

    public Object unformatString(String rep) {
        Class clazz = this.getContentClass();
        if (clazz == Boolean.class) {
            return Boolean.valueOf(rep);
        }
        if (clazz == Character.class) {
            if (rep.length() == 1) {
                return new Character(rep.charAt(0));
            }
            if (rep.trim().length() == 1) {
                return new Character(rep.trim().charAt(0));
            }
            throw new IllegalArgumentException();
        }
        if (clazz == Byte.class) {
            return Byte.valueOf(rep);
        }
        if (clazz == Short.class) {
            return Short.valueOf(rep);
        }
        if (clazz == Integer.class) {
            return Integer.valueOf(rep);
        }
        if (clazz == Long.class) {
            return Long.valueOf(rep);
        }
        if (clazz == Float.class) {
            if (rep.trim().length() == 0) {
                return new Float(Float.NaN);
            }
            return Float.valueOf(rep);
        }
        if (clazz == Double.class || clazz == Number.class) {
            if (rep.trim().length() == 0) {
                return new Double(Double.NaN);
            }
            return Double.valueOf(rep);
        }
        if (clazz == String.class) {
            return rep;
        }
        throw new IllegalArgumentException("No unformatter available for " + clazz.getName());
    }

    public String toString() {
        StringBuffer typeRep = new StringBuffer();
        typeRep.append(DefaultValueInfo.formatClass(this.getContentClass()));
        int trlen = typeRep.length();
        if (typeRep.charAt(trlen - 2) == '[' && typeRep.charAt(trlen - 1) == ']') {
            typeRep.insert(trlen - 1, DefaultValueInfo.formatShape(this.getShape()));
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append("(").append(typeRep).append(")");
        if (this.getUnitString() != null && this.getUnitString().trim().length() > 0) {
            buf.append("/").append(this.getUnitString().trim());
        }
        return buf.toString();
    }

    private static int[] getActualShape(int[] basicShape, int nel) {
        int ndim;
        int[] ashape = (int[])basicShape.clone();
        if (ashape[(ndim = ashape.length) - 1] <= 0) {
            int slice = 1;
            for (int i = 0; i < ndim - 1; ++i) {
                slice *= ashape[i];
            }
            ashape[ndim - 1] = (nel + slice - 1) / slice;
        }
        return ashape;
    }

    static {
        $assertionsDisabled = !DefaultValueInfo.class.desiredAssertionStatus();
        trailDigits = Pattern.compile("\\.([0-9]+)$");
        trailSpaces = Pattern.compile("( +)$");
    }
}

