/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.nc.testsupport;

import alma.ACSErrTypeCommon.wrappers.AcsJIllegalStateEventEx;
import alma.acs.exceptions.AcsJException;
import alma.acs.nc.AcsEventPublisher;
import alma.acs.nc.testsupport.InMemoryNcFake;
import alma.acs.util.UTCUtility;
import alma.acsnc.EventDescription;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

class InMemoryPublisher<T>
implements AcsEventPublisher<T> {
    private final InMemoryNcFake nc;
    private final Logger logger;
    protected final String publisherName;
    private final AtomicLong count = new AtomicLong(0L);

    InMemoryPublisher(InMemoryNcFake nc, String publisherName, Logger logger) {
        this.nc = nc;
        this.publisherName = publisherName;
        this.logger = logger;
    }

    @Override
    public void publishEvent(T customStruct) throws AcsJException {
        long currentOmgTime = UTCUtility.utcJavaToOmg((long)System.currentTimeMillis());
        EventDescription desc = new EventDescription(this.publisherName, currentOmgTime, this.count.getAndIncrement());
        this.nc.pushData(customStruct, desc);
    }

    @Override
    public void disconnect() throws AcsJIllegalStateEventEx {
        this.nc.disconnectPublisher(this);
    }

    @Override
    public void enableEventQueue(int queueSize, AcsEventPublisher.EventProcessingHandler<T> handler) {
        throw new UnsupportedOperationException("Event queue handling is currently not supported for in-memory fake NCs. See http://jira.alma.cl/browse/COMP-2890.");
    }

    @Override
    public boolean increaseEventBufferSize(int bufferSize) {
        throw new UnsupportedOperationException("Event queue handling is currently not supported for in-memory fake NCs. See http://jira.alma.cl/browse/COMP-2890.");
    }

    @Override
    public int getEventBufferSize() {
        throw new UnsupportedOperationException("Event queue handling is currently not supported for in-memory fake NCs. See http://jira.alma.cl/browse/COMP-2890.");
    }

    @Override
    public void setEventProcessingHandler(AcsEventPublisher.EventProcessingHandler<T> handler) {
        throw new UnsupportedOperationException("Event queue handling is currently not supported for in-memory fake NCs. See http://jira.alma.cl/browse/COMP-2890.");
    }

    public long getEventCount() {
        return this.count.get();
    }
}

