/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.util;

import alma.acs.util.ACSPorts;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileHelper {
    public static String getTempFileName(String fileNameProperty, String fileName) {
        String propertyVal;
        String ACS_TEMP_DIR = "ACS.tmp";
        String TEMP_DIR = "tmp";
        String DEFAULT_TEMP_DIR_ENV_VAR = "ACSDATA";
        Object filePath = null;
        if (fileNameProperty != null && (propertyVal = System.getProperty(fileNameProperty)) != null) {
            return propertyVal;
        }
        if (fileName == null) {
            return new String();
        }
        propertyVal = System.getProperty("ACS.tmp");
        if (propertyVal != null) {
            filePath = propertyVal;
        } else {
            String defaultTempDir = System.getenv("ACSDATA");
            filePath = defaultTempDir != null ? defaultTempDir : "";
            filePath = (String)filePath + File.separatorChar;
            filePath = (String)filePath + "tmp";
            String hostName = System.getenv("HOST");
            if (hostName != null) {
                filePath = (String)filePath + File.separatorChar;
                filePath = (String)filePath + hostName;
            }
        }
        filePath = (String)filePath + File.separatorChar;
        filePath = (String)filePath + "ACS_INSTANCE." + ACSPorts.getBasePort();
        filePath = (String)filePath + File.separatorChar;
        filePath = (String)filePath + fileName;
        return filePath;
    }

    public static void setFileAttributes(String attribs, String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        String command = "chmod -R " + attribs + " " + filePath;
        try {
            Runtime.getRuntime().exec(command).waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File dest, boolean preserveTime) throws IOException {
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            dest.getParentFile().mkdirs();
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            long size = ((FileChannel)in).size();
            MappedByteBuffer buf = ((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, size);
            ((FileChannel)out).write(buf);
            if (preserveTime) {
                dest.setLastModified(source.lastModified());
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

