/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.archive.zoom;

import alma.acs.logging.archive.zoom.ZoomException;
import alma.acs.logging.engine.io.IOHelper;
import alma.acs.logging.engine.io.IOPorgressListener;
import com.cosylab.logging.engine.ACS.ACSRemoteErrorListener;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.engine.InvalidFilterConstraintException;
import com.cosylab.logging.engine.MinMaxFilter;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class FileHelper
implements ACSRemoteErrorListener {
    public final LogTypeHelper minLogLevel;
    public final LogTypeHelper maxLogLevel;
    public final long startTime;
    public final long endTime;
    private final File inputFile;
    private IOHelper ioHelper;
    private boolean errorParsingLogs = false;
    private ACSRemoteErrorListener externalErrorListener = null;

    public FileHelper(File inFile, long start, long end, LogTypeHelper lowLvl, LogTypeHelper hiLvl) throws ZoomException {
        if (inFile == null) {
            throw new IllegalArgumentException("The file can't be null");
        }
        if (!inFile.canRead()) {
            throw new ZoomException(inFile.getAbsolutePath() + " is unreadable");
        }
        if (end < start || start < 0L) {
            throw new IllegalArgumentException("Invalid time range [" + start + ", " + end + "]");
        }
        if (lowLvl == null) {
            throw new IllegalArgumentException("The min log level can't be null");
        }
        if (hiLvl == null) {
            throw new IllegalArgumentException("The max log level can't be null");
        }
        if (lowLvl.ordinal() > hiLvl.ordinal()) {
            throw new IllegalArgumentException("Invalid log level range [" + lowLvl + ", " + hiLvl + "]");
        }
        try {
            this.ioHelper = new IOHelper();
        }
        catch (Throwable t) {
            throw new ZoomException("Error instantiating te helper for I/O", t);
        }
        this.startTime = start;
        this.endTime = end;
        this.minLogLevel = lowLvl;
        this.maxLogLevel = hiLvl;
        this.inputFile = inFile;
    }

    public boolean loadLogs(ACSRemoteLogListener logListener, IOPorgressListener ioListener, ACSRemoteErrorListener errorListener) throws ZoomException, FileNotFoundException {
        FiltersVector filters = this.setupFilters();
        this.ioHelper.setFilters(filters);
        this.errorParsingLogs = false;
        this.externalErrorListener = errorListener;
        FileReader fileReader = new FileReader(this.inputFile);
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            this.ioHelper.loadLogs(reader, logListener, null, (ACSRemoteErrorListener)this, ioListener);
        }
        catch (Throwable t) {
            throw new ZoomException("Error loading logs from file", t);
        }
        return !this.errorParsingLogs;
    }

    private FiltersVector setupFilters() throws ZoomException {
        FiltersVector filters = new FiltersVector();
        MinMaxFilter dateFilter = null;
        MinMaxFilter levelFilter = null;
        try {
            dateFilter = new MinMaxFilter(LogField.TIMESTAMP, false, (Comparable)Long.valueOf(this.startTime), (Comparable)Long.valueOf(this.endTime), false);
            levelFilter = new MinMaxFilter(LogField.ENTRYTYPE, false, (Comparable)this.minLogLevel, (Comparable)this.maxLogLevel, false);
        }
        catch (InvalidFilterConstraintException e) {
            throw new ZoomException("Error setting the filters", e);
        }
        filters.addFilter((Filter)dateFilter, true);
        filters.addFilter((Filter)levelFilter, true);
        return filters;
    }

    public void errorReceived(String xml) {
        this.errorParsingLogs = true;
        if (this.externalErrorListener != null) {
            this.externalErrorListener.errorReceived(xml);
        }
    }

    public void stopLoading() {
        if (this.ioHelper != null) {
            this.ioHelper.stopIO();
        }
    }
}

