/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.geom.Point2D;
import javax.media.jai.JaiI18N;
import javax.media.jai.Warp;

public final class WarpGrid
extends Warp {
    private int xStart;
    private int yStart;
    private int xEnd;
    private int yEnd;
    private int xStep;
    private int yStep;
    private int xNumCells;
    private int yNumCells;
    private float[] xWarpPos;
    private float[] yWarpPos;

    private void initialize(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.xStart = n;
        this.yStart = n4;
        this.xEnd = n + n2 * n3;
        this.yEnd = n4 + n5 * n6;
        this.xStep = n2;
        this.yStep = n5;
        this.xNumCells = n3;
        this.yNumCells = n6;
        int n7 = n3 + 1;
        int n8 = n6 + 1;
        int n9 = n8 * n7;
        this.xWarpPos = new float[n9];
        this.yWarpPos = new float[n9];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n9) {
            this.xWarpPos[n11] = fArray[n10++];
            this.yWarpPos[n11] = fArray[n10++];
            ++n11;
        }
    }

    public WarpGrid(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        if (fArray.length != 2 * (n3 + 1) * (n6 + 1)) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpGrid0"));
        }
        this.initialize(n, n2, n3, n4, n5, n6, fArray);
    }

    public WarpGrid(Warp warp, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 2 * (n3 + 1) * (n6 + 1);
        float[] fArray = new float[n7];
        fArray = warp.warpSparseRect(n, n4, n3 * n2 + 1, n6 * n5 + 1, n2, n5, fArray);
        this.initialize(n, n2, n3, n4, n5, n6, fArray);
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getYStart() {
        return this.yStart;
    }

    public int getXStep() {
        return this.xStep;
    }

    public int getYStep() {
        return this.yStep;
    }

    public int getXNumCells() {
        return this.xNumCells;
    }

    public int getYNumCells() {
        return this.yNumCells;
    }

    public float[] getXWarpPos() {
        return this.xWarpPos;
    }

    public float[] getYWarpPos() {
        return this.yWarpPos;
    }

    private float[] noWarpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n9 = n3;
        while (n9 <= n4) {
            int n10 = n7;
            n7 += n8;
            int n11 = n;
            while (n11 <= n2) {
                fArray[n10++] = n11;
                fArray[n10++] = n9;
                n11 += n5;
            }
            n9 += n6;
        }
        return fArray;
    }

    public float[] warpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        int n7;
        int n8 = 2 * ((n3 + n5 - 1) / n5);
        if (fArray == null) {
            fArray = new float[n8 * ((n4 + n6 - 1) / n6)];
        }
        int n9 = n;
        int n10 = n + n3 - 1;
        int n11 = n2;
        int n12 = n2 + n4 - 1;
        if (n11 >= this.yEnd || n12 < this.yStart || n9 >= this.xEnd || n10 < this.xStart) {
            return this.noWarpSparseRect(n9, n10, n11, n12, n5, n6, 0, n8, fArray);
        }
        if (n11 < this.yStart) {
            n7 = (this.yStart - n11 + n6 - 1) / n6;
            this.noWarpSparseRect(n9, n10, n11, this.yStart - 1, n5, n6, 0, n8, fArray);
            n11 += n7 * n6;
        }
        if (n12 >= this.yEnd) {
            n7 = (this.yEnd - n2 + n6 - 1) / n6;
            this.noWarpSparseRect(n9, n10, n2 + n7 * n6, n12, n5, n6, n7 * n8, n8, fArray);
            n12 = n2 + (n7 - 1) * n6;
        }
        if (n9 < this.xStart) {
            n7 = (this.xStart - n9 + n5 - 1) / n5;
            this.noWarpSparseRect(n9, this.xStart - 1, n11, n12, n5, n6, (n11 - n2) / n6 * n8, n8, fArray);
            n9 += n7 * n5;
        }
        if (n10 >= this.xEnd) {
            n7 = (this.xEnd - n + n5 - 1) / n5;
            this.noWarpSparseRect(n + n7 * n5, n10, n11, n12, n5, n6, (n11 - n2) / n6 * n8 + n7 * 2, n8, fArray);
            n10 = n + (n7 - 1) * n5;
        }
        int[] nArray = new int[this.xNumCells];
        int n13 = n9;
        while (n13 <= n10) {
            int n14 = (n13 - this.xStart) / this.xStep;
            nArray[n14] = nArray[n14] + 1;
            n13 += n5;
        }
        int n15 = (n11 - n2) / n6 * n8 + (n9 - n) / n5 * 2;
        int n16 = this.xNumCells + 1;
        float f = (float)n5 / (float)this.xStep;
        int n17 = n11;
        while (n17 <= n12) {
            int n18 = n15;
            n15 += n8;
            int n19 = (n17 - this.yStart) / this.yStep;
            int n20 = this.yStart + n19 * this.yStep;
            float f2 = ((float)n17 + 0.5f - (float)n20) / (float)this.yStep;
            float f3 = (1.0f - f2) * f;
            float f4 = f2 * f;
            int n21 = n9;
            while (n21 <= n10) {
                int n22 = (n21 - this.xStart) / this.xStep;
                int n23 = this.xStart + n22 * this.xStep;
                float f5 = ((float)n21 + 0.5f - (float)n23) / (float)this.xStep;
                int n24 = n19 * n16 + n22;
                float f6 = this.xWarpPos[n24];
                float f7 = this.yWarpPos[n24];
                float f8 = this.xWarpPos[++n24];
                float f9 = this.yWarpPos[n24];
                float f10 = this.xWarpPos[n24 += this.xNumCells];
                float f11 = this.yWarpPos[n24];
                float f12 = this.xWarpPos[++n24];
                float f13 = this.yWarpPos[n24];
                float f14 = f6 + (f8 - f6) * f5;
                float f15 = f7 + (f9 - f7) * f5;
                float f16 = f10 + (f12 - f10) * f5;
                float f17 = f11 + (f13 - f11) * f5;
                float f18 = f14 + (f16 - f14) * f2;
                float f19 = f15 + (f17 - f15) * f2;
                float f20 = (f8 - f6) * f3 + (f12 - f10) * f4;
                float f21 = (f9 - f7) * f3 + (f13 - f11) * f4;
                int n25 = nArray[n22];
                int n26 = 0;
                while (n26 < n25) {
                    fArray[n18++] = f18 - 0.5f;
                    fArray[n18++] = f19 - 0.5f;
                    f18 += f20;
                    f19 += f21;
                    n21 += n5;
                    ++n26;
                }
            }
            n17 += n6;
        }
        return fArray;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        float[] fArray = this.warpSparseRect((int)point2D.getX(), (int)point2D.getY(), 2, 2, 1, 1, null);
        double d = point2D.getX() - (double)((int)point2D.getX());
        double d2 = 1.0 - d;
        double d3 = point2D.getY() - (double)((int)point2D.getY());
        double d4 = 1.0 - d3;
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(((double)fArray[0] * d2 + (double)fArray[2] * d) * d4 + ((double)fArray[4] * d2 + (double)fArray[6] * d) * d3, ((double)fArray[1] * d2 + (double)fArray[3] * d) * d4 + ((double)fArray[5] * d2 + (double)fArray[7] * d) * d3);
        return point2D2;
    }
}

