/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.capabilities;

import alma.observatorycharacteristics.configuration.Frequency;
import alma.observatorycharacteristics.configuration.FrequencyList;
import alma.observatorycharacteristics.configuration.NonSiderealObjectType;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.configuration.OTTime;
import alma.observatorycharacteristics.configuration.PrincipalALMAArrayType;
import alma.observatorycharacteristics.configuration.Sensitivity;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.data.AbstractTargetParametersData;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Time;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class OTConfigurationHelper {
    public static NonSiderealObjectType mapSiderealObject(@NonNull String string) throws UnableToMapSiderealObjectException {
        if (string == null) {
            throw new NullPointerException("nonSiderealObject is marked non-null but is null");
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_JUPITER)) {
            return NonSiderealObjectType.JUPITER;
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_SATURN)) {
            return NonSiderealObjectType.SATURN;
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_URANUS)) {
            return NonSiderealObjectType.URANUS;
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_NEPTUNE)) {
            return NonSiderealObjectType.NEPTUNE;
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_GANYMEDE)) {
            return NonSiderealObjectType.GANYMEDE;
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_EUROPA)) {
            return NonSiderealObjectType.EUROPA;
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_CALLISTO)) {
            return NonSiderealObjectType.CALLISTO;
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_IO)) {
            return NonSiderealObjectType.IO;
        }
        if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_TITAN)) {
            return NonSiderealObjectType.TITAN;
        }
        throw new UnableToMapSiderealObjectException(string + " cannot be mapped");
    }

    public static PrincipalALMAArrayType mapPrincipalArray(Array array) {
        switch (array) {
            case ARRAY_12M: {
                return PrincipalALMAArrayType.TWELVE_M;
            }
            case ARRAY_7M: {
                return PrincipalALMAArrayType.ACA_7_M;
            }
            case ARRAY_TP: {
                return PrincipalALMAArrayType.TP;
            }
        }
        throw new IllegalArgumentException("Unknown array type " + String.valueOf((Object)array));
    }

    public static Array mapPrincipalArray(PrincipalALMAArrayType principalALMAArrayType) {
        switch (principalALMAArrayType) {
            case TWELVE_M: {
                return Array.ARRAY_12M;
            }
            case ACA_7_M: {
                return Array.ARRAY_7M;
            }
            case TP: {
                return Array.ARRAY_TP;
            }
        }
        throw new IllegalArgumentException("Unknown array type " + String.valueOf((Object)principalALMAArrayType));
    }

    public static List<alma.valuetypes.Frequency> getFrequencyList(@NonNull FrequencyList frequencyList) {
        if (frequencyList == null) {
            throw new NullPointerException("frequencyList is marked non-null but is null");
        }
        return frequencyList.getFrequency().stream().map(frequency -> alma.valuetypes.Frequency.createFrequency((double)frequency.getValue(), (String)frequency.getUnit().value())).toList();
    }

    public static Angle getAngle(@NonNull alma.observatorycharacteristics.configuration.Angle angle) {
        if (angle == null) {
            throw new NullPointerException("angle is marked non-null but is null");
        }
        return Angle.createAngle((double)angle.getValue(), (String)angle.getUnit().value());
    }

    public static alma.valuetypes.Frequency getFrequency(@NonNull Frequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("frequency is marked non-null but is null");
        }
        return alma.valuetypes.Frequency.createFrequency((double)frequency.getValue(), (String)frequency.getUnit().value());
    }

    public static alma.valuetypes.Sensitivity getSensitivity(@NonNull Sensitivity sensitivity) {
        if (sensitivity == null) {
            throw new NullPointerException("sensitivity is marked non-null but is null");
        }
        return alma.valuetypes.Sensitivity.createSensitivity((double)sensitivity.getValue(), (String)sensitivity.getUnit().value());
    }

    public static Time getTime(@NonNull OTTime oTTime) {
        if (oTTime == null) {
            throw new NullPointerException("otTime is marked non-null but is null");
        }
        return Time.createTime((double)oTTime.getValue(), (String)oTTime.getUnit().value());
    }

    public static String[] getFrequencyListAsStr(List<alma.valuetypes.Frequency> list, String string) {
        return (String[])list.stream().map(frequency -> Double.toString(frequency.getContentInUnits(string))).toArray(String[]::new);
    }

    public static String[] getSolarFrequenciesAsStr(@NonNull List<OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand> list, String string) {
        if (list == null) {
            throw new NullPointerException("solarBands is marked non-null but is null");
        }
        return (String[])list.stream().map(solarBand -> Double.toString(OTConfigurationHelper.getFrequency(solarBand.getStandardFrequency()).getContentInUnits(string))).toArray(String[]::new);
    }

    public static Set<ReceiverBand> getReceiverBands(@NonNull List<Integer> list) {
        if (list == null) {
            throw new NullPointerException("receiverBands is marked non-null but is null");
        }
        return list.stream().map(ReceiverBand::getReceiverBand).collect(Collectors.toSet());
    }

    public static Longitude getLongitude(alma.observatorycharacteristics.configuration.Angle angle) {
        return Longitude.createLongitude((double)angle.getValue(), (String)angle.getUnit().value());
    }

    public static Latitude getLatitude(alma.observatorycharacteristics.configuration.Angle angle) {
        return Latitude.createLatitude((double)angle.getValue(), (String)angle.getUnit().value());
    }

    private OTConfigurationHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class UnableToMapSiderealObjectException
    extends Exception {
        public UnableToMapSiderealObjectException(String string) {
            super(string);
        }
    }
}

