/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ScienceSpectralWindowT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.obsproject.RepresentativeWindowInterface;
import alma.obsprep.bo.obsproject.ScienceSpectralWindowFactory;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.data.ScienceSpectralWindowData;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.Range;
import alma.obsprep.util.TextUtils;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;

public class ScienceSpectralWindow
extends ScienceSpectralWindowData
implements Comparable<ScienceSpectralWindow>,
RepresentativeWindowInterface {
    private static Map<Integer, Number> spectralAverageBUFSFactorMapping = Map.of(1, 2.6666666666666665, 2, 3.2, 4, 4.923076923076923, 8, 8.827586206896552, 16, 16.78688524590164);
    protected CorrConfigMode corrConfigMode = null;
    public static final int GROUP_NOTSPECIFIED = -1;
    public static final int DefaultTDMCorrConfigModeNumber = 142;
    public static final int DEFAULT_VLBI_FDM_CORR_CONFIG_MODE_NUMBER = 52;
    private final UUID uuid = UUID.randomUUID();
    private int lastGroup = -1;

    public ScienceSpectralWindow(ScienceSpectralWindowT scienceSpectralWindowT) {
        super(scienceSpectralWindowT);
    }

    public void deleteSplatalogId() {
        this.getCastorObject().deleteSplatalogId();
    }

    public int getPreviousGroupIndex() {
        return this.lastGroup;
    }

    public void setLastGroup(int n) {
        this.lastGroup = n;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void wrapObjects(ReferenceablesMap referenceablesMap, List<ReferenceableProxy<? extends IBusinessObject>> list) {
        super.wrapObjects(referenceablesMap, list);
        this.getCenterFrequency().addPropertyChangeListener(this.getCentreFrequencyListener());
    }

    public void initAsNew() {
        super.initAsNew();
        this.setCorrConfigMode(-1);
        this.setGroupResourceUse(GROUPRESOURCEUSE_FULL);
        this.setGroupIndex(-1);
        this.getCenterFrequency().addPropertyChangeListener(this.getCentreFrequencyListener());
    }

    private final PropertyChangeListener getCentreFrequencyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent == null || !propertyChangeEvent.getPropertyName().endsWith(".AbstractDoubleWithUnit.content")) {
                    return;
                }
                Frequency frequency = ScienceSpectralWindow.this.getCenterFrequency();
                ScienceSpectralWindow.this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.ScienceSpectralWindow.centerFrequency", (Object)frequency);
            }
        };
    }

    public synchronized ScienceSpectralWindow deepCopy() {
        ScienceSpectralWindow scienceSpectralWindow = super.deepCopy();
        scienceSpectralWindow.getCenterFrequency().addPropertyChangeListener(this.getCentreFrequencyListener());
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, double d2, double d3) {
        return ScienceSpectralWindowFactory.createScienceSpectralWindow(d, string, d2, d3);
    }

    public static ScienceSpectralWindow createSingleContinuum() {
        return ScienceSpectralWindowFactory.createSingleTDMContinuum();
    }

    public static ScienceSpectralWindow createSingleVLBIContinuumWindow() {
        return ScienceSpectralWindowFactory.createSingleVLBIContinuumWindow();
    }

    public String shortDescription() {
        double d;
        Object object = this.getTransitionName();
        if (((String)object).length() == 0) {
            object = "Line";
        }
        object = (String)object + (String)((d = this.getCenterFrequency().getContentInGHz()) == 0.0 ? "" : "@" + TextUtils.format(d, 0, 0));
        return object;
    }

    public CorrConfigMode gettrueCorrConfigMode() {
        return this.corrConfigMode;
    }

    @Override
    public CorrConfigMode getCorrConfigMode() {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        if (this.corrConfigMode == null) {
            Set<CorrConfigMode> set;
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)this.getParent();
            CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(spectralSetupParameters.getPolarisation());
            Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode(this.getAdvancedWindowSetup().getOversampling(), corrPolarization);
            Set<CorrConfigMode> set3 = oTConfigModeDecoder.findMode((Frequency)((Object)this.getBandWidth()), (Frequency)((Object)this.getSpectralResolution()), set2);
            boolean bl = false;
            if (this.gettrueAdvancedWindowSetup() != null) {
                bl = this.gettrueAdvancedWindowSetup().getAddedSensitivity();
            }
            if ((set = oTConfigModeDecoder.findModeWithStrictImprovedModeCompliance(this.getFraction(), bl, set3)).isEmpty()) {
                this.corrConfigMode = CorrConfigMode.INVALID_CORRCONFIGMODE;
                if (this.isSingleContinuum()) {
                    this.updateContinuumCorrMode();
                }
            } else if (set.size() == 1) {
                this.corrConfigMode = set.toArray(new CorrConfigMode[1])[0];
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Can not identify the CorrConfigMode for this setting : ");
                int n = Integer.MAX_VALUE;
                for (CorrConfigMode corrConfigMode : set) {
                    stringBuilder.append(corrConfigMode).append(" ");
                    if (corrConfigMode.getFraction().getUnits() >= n) continue;
                    this.corrConfigMode = corrConfigMode;
                    n = corrConfigMode.getFraction().getUnits();
                }
                stringBuilder.append("\n" + this.corrConfigMode.getMode() + " is selected.");
                Log.logger((Object)this).info(stringBuilder.toString());
            }
        }
        return this.corrConfigMode;
    }

    public boolean isModeFilterTDM() {
        return this.getCorrConfigMode().getFilter().equals((Object)CorrFilter.TDM);
    }

    public void setCorrConfigMode(@NonNull CorrConfigMode corrConfigMode) {
        if (corrConfigMode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.corrConfigMode = corrConfigMode;
        if (corrConfigMode.isValid()) {
            this.getBandWidth().setContentInMHz(corrConfigMode.getNominalBandwidth().getContentInMHz());
            this.getSpectralResolution().setContentInMHz(corrConfigMode.getResolution().getContentInMHz());
            this.setGroupResourceUse(corrConfigMode.getFraction().getResourceUse());
        }
    }

    public void setCorrConfigMode(int n) {
        this.setCorrConfigMode(CorrConfigMode.getCorrConfigMode(n));
    }

    public int getNumberOfChannels() {
        CorrConfigMode corrConfigMode = this.getCorrConfigMode();
        if (corrConfigMode != null && corrConfigMode.isValid()) {
            return corrConfigMode.getNominalChannels();
        }
        UserFrequency userFrequency = this.getBandWidth();
        UserFrequency userFrequency2 = this.getSpectralResolution();
        if (userFrequency == null || userFrequency2 == null) {
            return 0;
        }
        return (int)Math.round(userFrequency.getContentInMHz() / userFrequency2.getContentInMHz());
    }

    public String formatWindowDescription(Velocity velocity, boolean bl) {
        if (this.getCorrConfigMode().isValid()) {
            Frequency frequency;
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)this.getParent();
            Frequency frequency2 = frequency = bl ? this.getImageSPWSkyCenterFrequency(spectralSetupParameters.getLO1Frequency()) : this.getCenterFrequency();
            if (this.getIsSkyFrequency()) {
                return this.getCorrConfigMode().formatWindowDescription(frequency, this.getAdvancedWindowSetup());
            }
            return this.getCorrConfigMode().formatWindowDescription(velocity.dopplerShift(frequency), this.getAdvancedWindowSetup());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%-8s", CorrConfigMode.formatBandwidth((Frequency)((Object)this.getBandWidth()))));
        stringBuilder.append(", ");
        stringBuilder.append(String.format("%-8s", CorrConfigMode.formatResolution((Frequency)((Object)this.getSpectralResolution()))));
        return stringBuilder.toString();
    }

    public void resetCorrConfigMode() {
        this.corrConfigMode = null;
    }

    public boolean promptsUpdate() {
        if (!this.getCorrConfigMode().isValid()) {
            return true;
        }
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        boolean bl = this.getAdvancedWindowSetup().getOversampling();
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(bl, this.getCorrPolarization());
        boolean bl2 = this.getAdvancedWindowSetup().getAddedSensitivity();
        Set<CorrConfigMode> set2 = oTConfigModeDecoder.findModeWithStrictImprovedModeCompliance(this.getFraction(), bl2, set);
        Set<CorrConfigMode> set3 = oTConfigModeDecoder.findMode((Frequency)((Object)this.getBandwidth()), (Frequency)((Object)this.getSpectralResolution()), set2);
        if (set3.isEmpty()) {
            Set<CorrConfigMode> set4 = oTConfigModeDecoder.findMode(CorrFilter.TDM);
            Set<CorrConfigMode> set5 = oTConfigModeDecoder.findMode(this.getCorrPolarization(), set4);
            Set<CorrConfigMode> set6 = oTConfigModeDecoder.findMode(this.getFraction(), set5);
            set3 = oTConfigModeDecoder.findMode((Frequency)((Object)this.getBandwidth()), (Frequency)((Object)this.getSpectralResolution()), set6);
            return set3.isEmpty();
        }
        return false;
    }

    public CorrFraction getFraction() {
        return CorrFraction.getCorrFraction(this.getGroupResourceUse());
    }

    public boolean isSingleContinuum() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return false;
        }
        String string = spectralSetupParameters.getType();
        return "continuum".equals(string);
    }

    public static Frequency getSingleContinuumBandwidth() {
        return CorrConfigMode.getCorrConfigMode(142).getEffectiveBandwidth();
    }

    public Frequency getEffectiveBandwidth() {
        return this.getCorrConfigMode().getEffectiveBandwidth();
    }

    public FrequencyRange getEffectiveBandwidthRange() {
        return FrequencyRange.fastCentredOn(this.getCenterFrequencySky(), this.getEffectiveBandwidth());
    }

    public UserFrequency getSpectralResolution() {
        UserFrequency userFrequency = super.getSpectralResolution();
        if (userFrequency.getObservingFrequency() == null) {
            userFrequency.setObservingFrequency(this.getCenterFrequency());
        }
        return userFrequency;
    }

    public UserFrequency getSpectralResolutionSmoothed() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        return spectralSetupParameters.isSingleContinuum() ? this.getSpectralResolutionSmoothedForSingleContinuum() : this.getSpectralResolutionSmoothedNonSingleContinuum();
    }

    private UserFrequency getSpectralResolutionSmoothedNonSingleContinuum() {
        double d = this.getBandWidth().getContentInMHz() / (double)this.getNumberOfChannels();
        double d2 = this.getSpectralAveragingFactor() * d;
        UserFrequency userFrequency = this.getSpectralResolution().deepCopy();
        userFrequency.setContentInMHz(d2);
        return userFrequency;
    }

    public double getSpectralAveragingFactor() {
        int n = this.getAdvancedWindowSetup().getSmoothingFactor();
        if (!spectralAverageBUFSFactorMapping.containsKey(n)) {
            throw new RuntimeException("Mapping for spectralAverage " + n + " not found");
        }
        return spectralAverageBUFSFactorMapping.getOrDefault(n, 2.6666666666666665).doubleValue();
    }

    public static double getSpectralAveragingFactor(int n) {
        if (!spectralAverageBUFSFactorMapping.containsKey(n)) {
            throw new RuntimeException("Mapping for spectralAverage " + n + " not found");
        }
        return spectralAverageBUFSFactorMapping.getOrDefault(n, 2.6666666666666665).doubleValue();
    }

    private UserFrequency getSpectralResolutionSmoothedForSingleContinuum() {
        UserFrequency userFrequency = this.getSpectralResolution().deepCopy();
        SpectralAverage spectralAverage = SpectralAverage.getValue(this.getAdvancedWindowSetup().getSmoothingFactor());
        double d = 0.0;
        try {
            d = spectralAverage.getResolutionScalingFactor(this.getAdvancedWindowSetup().getSmoothingFunction());
        }
        catch (SpectralAverage.UnknownWindowingFunctionException unknownWindowingFunctionException) {
            return userFrequency;
        }
        double d2 = userFrequency.getContent() * d;
        userFrequency.setContent(d2);
        return userFrequency;
    }

    public UserFrequency getResolutionPerPoln() {
        UserFrequency userFrequency = this.isSingleContinuum() ? UserFrequency.createUserFrequency(ScienceSpectralWindow.getSingleContinuumBandwidth()) : this.getSpectralResolution();
        return userFrequency;
    }

    public Frequency getEffectiveResolution() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        int n = spectralSetupParameters == null ? 1 : spectralSetupParameters.getPolarizationFactor();
        UserFrequency userFrequency = this.getResolutionPerPoln();
        return (Frequency)userFrequency.multiply(n);
    }

    public void updateContinuumCorrMode() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        if (this.isSingleContinuum()) {
            CorrPolarization corrPolarization = this.getCorrPolarization();
            CorrelatorExpert correlatorExpert = CorrelatorExpert.getBLInstance();
            CorrConfigMode corrConfigMode = correlatorExpert.getContinuumMode(corrPolarization);
            this.setCorrConfigMode(corrConfigMode);
        }
    }

    public Frequency getOpacityReferenceFrequency(Velocity velocity) {
        return this.getIsSkyFrequency() ? this.getCenterFrequency() : this.getCenterFrequency().dopplerShifted(velocity);
    }

    public Frequency getCenterFrequencyRest() {
        if (!this.getIsSkyFrequency()) {
            return super.getCenterFrequency();
        }
        Velocity velocity = this.getSourceVelocity();
        Frequency frequency = super.getCenterFrequency();
        return velocity.reverseShift(frequency);
    }

    public Frequency getCenterFrequencySky() {
        if (this.getIsSkyFrequency()) {
            return super.getCenterFrequency();
        }
        Velocity velocity = this.getSourceVelocity();
        Frequency frequency = super.getCenterFrequency();
        return velocity.dopplerShift(frequency);
    }

    public VupRange<Frequency> getSkyFrequencyNominalRange() {
        return this.getSkyFrequencyRange(false);
    }

    public VupRange<Frequency> getSkyFrequencyEffectiveRange() {
        return this.getSkyFrequencyRange(true);
    }

    private VupRange<Frequency> getSkyFrequencyRange(boolean bl) {
        Velocity velocity = this.getSourceVelocity();
        Object object = bl ? this.getEffectiveBandwidth() : this.getBandwidth();
        Frequency frequency = (Frequency)object.half();
        Frequency frequency2 = this.getIsSkyFrequency() ? this.getCenterFrequency() : this.getCenterFrequency().dopplerShifted(velocity);
        Frequency frequency3 = (Frequency)frequency2.minus((AbstractDoubleWithUnit)frequency);
        Frequency frequency4 = (Frequency)frequency2.plus((AbstractDoubleWithUnit)frequency);
        return new FrequencyRange(frequency3, frequency4);
    }

    public void initAttribsAndPartsFrom(IBusinessObject iBusinessObject, Copier copier) {
        super.initAttribsAndPartsFrom(iBusinessObject, copier);
        ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)iBusinessObject;
        if (this.gettrueCorrConfigMode() != null) {
            this.setCorrConfigMode(scienceSpectralWindow.gettrueCorrConfigMode());
        }
    }

    @Override
    public int compareTo(ScienceSpectralWindow scienceSpectralWindow) {
        if (this == scienceSpectralWindow) {
            return 0;
        }
        if (this.getCenterFrequency().getContent() < scienceSpectralWindow.getCenterFrequency().getContent()) {
            return -1;
        }
        if (this.getCenterFrequency().getContent() > scienceSpectralWindow.getCenterFrequency().getContent()) {
            return 1;
        }
        return 0;
    }

    public Frequency maxInRest() {
        return (Frequency)this.getCenterFrequencyRest().plus((AbstractDoubleWithUnit)((Frequency)this.getBandwidth().half()));
    }

    public Frequency minInRest() {
        return (Frequency)this.getCenterFrequencyRest().minus((AbstractDoubleWithUnit)((Frequency)this.getBandwidth().half()));
    }

    public Range<Frequency> getNativeFrequencyRange() {
        return this;
    }

    public double getVelocityResolutionInSky(Velocity velocity) {
        Frequency frequency = this.getCenterFrequency();
        if (!this.getIsSkyFrequency()) {
            frequency = velocity.dopplerShift(frequency);
        }
        Speed speed = Speed.getSpeedResolution((Frequency)((Object)this.getSpectralResolutionSmoothed()), frequency);
        return speed.getContentInUnits(Speed.UNIT_KM_S);
    }

    public static Frequency getSingleVLBIContinuumBandwidth() {
        return CorrConfigMode.getCorrConfigMode(52).getEffectiveBandwidth();
    }

    public Frequency getImageSPWSkyCenterFrequency(Frequency frequency) {
        double d = this.getCenterFrequencySky().getContentInGHz();
        double d2 = frequency.getContentInGHz();
        return Frequency.createFrequencyGHZ(2.0 * d2 - d);
    }

    public static Frequency getImageSPWSkyCenterFrequency(@NonNull Frequency frequency, @NonNull Frequency frequency2) {
        if (frequency == null) {
            throw new NullPointerException("skyLO1Freq is marked non-null but is null");
        }
        if (frequency2 == null) {
            throw new NullPointerException("spwCentreFreqSky is marked non-null but is null");
        }
        double d = frequency.getContentInGHz();
        return Frequency.createFrequencyGHZ(2.0 * d - frequency2.getContentInGHz());
    }

    public boolean isSidebandUsed() {
        return this.getAdvancedWindowSetup().getUseImage();
    }

    public static ScienceSpectralWindow createSingleVLBISpectralLineWindow() {
        return ScienceSpectralWindowFactory.createSingleVLBISpectralLineWindow();
    }

    public static Map<Integer, Number> getSpectralAverageBUFSFactorMapping() {
        return spectralAverageBUFSFactorMapping;
    }
}

