/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproposal.AbstractTimeAllocationStrategy;
import alma.obsprep.bo.obsproposal.AllToPiStrategy;
import alma.obsprep.bo.obsproposal.EqualDistributionStrategy;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.valuetypes.Time;

public class StandardTimeAllocationStrategy
extends AbstractTimeAllocationStrategy {
    private Time shortLimit = null;
    private final AbstractTimeAllocationStrategy defaultStrategy;
    private final AbstractTimeAllocationStrategy largeProposalStrategy;
    private final AbstractTimeAllocationStrategy vlbiStrategy;

    public StandardTimeAllocationStrategy(TimeAllocationBreakdown timeAllocationBreakdown) {
        super(timeAllocationBreakdown);
        this.defaultStrategy = new AllToPiStrategy(timeAllocationBreakdown);
        this.largeProposalStrategy = new EqualDistributionStrategy(timeAllocationBreakdown);
        this.vlbiStrategy = new EqualDistributionStrategy(timeAllocationBreakdown);
    }

    public void setShortProjectLimitHours(double d) {
        this.shortLimit = Time.createTime((double)d, (String)Time.UNIT_H);
    }

    public Time getTotalTime() {
        ObsProposal obsProposal = this.getProposal();
        if (obsProposal == null) {
            Log.logger((Object)this).warning("Unexpected ProposalFeedback : can not identify its ObsProposal");
            return Time.createTime();
        }
        return obsProposal.getTotalRequestedTime();
    }

    @Override
    protected void allocate() {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        assert (almaPolicies != null);
        ObsProposal obsProposal = this.getProposal();
        if (obsProposal == null) {
            Log.logger((Object)this).warning("Time allocation : can not identify its ObsProposal");
            return;
        }
        if (obsProposal.isLargeProgram()) {
            this.largeProposalStrategy.allocate();
        } else if (obsProposal.isVLBIorPhasedArray()) {
            this.vlbiStrategy.allocate();
        } else {
            this.defaultStrategy.allocate();
        }
    }
}

