/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.examples.SensitivityModel;
import alma.obsprep.guiutil.mvc.examples.SensitivityParameters;
import alma.obsprep.ot.editors.valuetypes.UserUnitValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.TextUtils;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Angle;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SensitivityEditor
extends Editor {
    public static final FieldID FREQUENCY_VUPFID = new FieldID("Sensitivity.frequency");
    public static final FieldID RESOLUTION_VUPFID = new FieldID("Sensitivity.resolution");
    public static final FieldID BEAMSIZE_FID = new FieldID("Sensitivity.beamsize");
    public static final FieldID SENSITIVITY_VUP = new FieldID("Sensitivity.sensitivity");
    public static final FieldID SENSITIVITY_FEEDBACK_VUP = new FieldID("Sensitivity.sensitivityFeedback");

    public SensitivityEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public SensitivityModel getModel() {
        return (SensitivityModel)super.getModel();
    }

    @Override
    protected void build() {
        SensitivityModel sensitivityModel = this.getModel();
        JLabel jLabel = new JLabel("Observing Frequency");
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(sensitivityModel.getFrequencyModel());
        this.register(valueUnitPairEditor, FREQUENCY_VUPFID);
        this.addLabeledWidget(jLabel, valueUnitPairEditor);
        jLabel = new JLabel("Beamsize");
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        this.register(jTextField, BEAMSIZE_FID);
        this.addLabeledWidget(jLabel, jTextField);
        jLabel = new JLabel("Resolution");
        valueUnitPairEditor = new UserUnitValueUnitPairEditor(sensitivityModel.getResolutionModel());
        this.register(valueUnitPairEditor, RESOLUTION_VUPFID);
        this.addLabeledWidget(jLabel, valueUnitPairEditor);
        jLabel = new JLabel("Sensitivity per Beam");
        valueUnitPairEditor = new UserUnitValueUnitPairEditor(sensitivityModel.getSensitivityModel());
        this.register(valueUnitPairEditor, SENSITIVITY_VUP);
        this.addLabeledWidget(jLabel, valueUnitPairEditor);
        jLabel = new JLabel("      \t(equivalent to)");
        valueUnitPairEditor = new ValueUnitPairEditor(sensitivityModel.getFeedbackModel());
        valueUnitPairEditor.getInput().setEditable(false);
        this.register(valueUnitPairEditor, SENSITIVITY_FEEDBACK_VUP);
        this.addLabeledWidget(jLabel, valueUnitPairEditor);
        this.layoutLabeledWidgets();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == BEAMSIZE_FID) {
            ValueUnitPair valueUnitPair = (ValueUnitPair)object;
            super.update(fieldID, TextUtils.format(valueUnitPair));
            return;
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        UnitMapConfigurator.configureUnitMaps();
        SensitivityModel sensitivityModel = new SensitivityModel(null);
        SensitivityEditor sensitivityEditor = new SensitivityEditor(sensitivityModel);
        SensitivityParameters sensitivityParameters = new SensitivityParameters();
        sensitivityParameters.getObservingFrequency().setContentInGHz(100.0);
        sensitivityParameters.getResolution().setContentAndUnit(1.0, Angle.UNIT_ARCSEC);
        sensitivityModel.setDocument(sensitivityParameters);
        TestUtilities.runTestApp(sensitivityEditor);
    }
}

