/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.ot.editors.misc.ValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.models.schedblock.AbstractSwitchingStateTableModel;
import alma.valuetypes.Time;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AbstractSwitchingStateTable
extends JPanel {
    private static final long serialVersionUID = 3900986305568104397L;
    public static final int TABLE_WIDTH = 800;
    protected Table table;

    public AbstractSwitchingStateTable(TableModel tableModel) {
        this.table = new Table(tableModel);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setToolTipText("tooltip");
        Dimension dimension = new Dimension(800, 64);
        this.table.setPreferredScrollableViewportSize(dimension);
        this.setupTableCellEditors();
        this.setupTableCellRenderers();
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.table);
        scrollWhenFocusedPane.setMinimumSize(this.table.getPreferredScrollableViewportSize());
        AbstractAction abstractAction = new AbstractAction("Add switching state"){
            private static final long serialVersionUID = 5980525964906967234L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractSwitchingStateTable.this.getMyModel().getRowCount();
                AbstractSwitchingStateTable.this.getMyModel().createAndSetNewAbstractSwitchingState();
                AbstractSwitchingStateTable.this.getMyModel().fireTableRowsInserted(n, n);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("Remove switching state"){
            private static final long serialVersionUID = -916190547151239822L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AbstractSwitchingStateTable.this.getMyModel().getRowCount();
                AbstractSwitchingStateTable.this.getMyModel().removeAbstractSwitchingCycle(AbstractSwitchingStateTable.this.table.getSelectedRow());
                AbstractSwitchingStateTable.this.getMyModel().fireTableRowsDeleted(n - 1, n - 1);
            }
        };
        tableModel.addTableModelListener(tableModelEvent -> {
            if (this.getMyModel().getRowCount() >= 16) {
                abstractAction.setEnabled(false);
            } else {
                abstractAction.setEnabled(true);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (this.table.getSelectedRowCount() == 0) {
                abstractAction2.setEnabled(false);
            } else {
                abstractAction2.setEnabled(true);
            }
        });
        abstractAction2.setEnabled(false);
        JButton jButton = new JButton(abstractAction);
        JButton jButton2 = new JButton(abstractAction2);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(jButton2);
        box.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 3));
        this.add(scrollWhenFocusedPane);
        this.add(box);
    }

    protected AbstractSwitchingStateTableModel getMyModel() {
        return (AbstractSwitchingStateTableModel)this.table.getModel();
    }

    protected void setupTableCellEditors() {
        ValueCellEditor.Natural natural = new ValueCellEditor.Natural();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(natural);
        ValueUnitPairCellEditor.TEMultipleEditor tEMultipleEditor = new ValueUnitPairCellEditor.TEMultipleEditor();
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(tEMultipleEditor);
        ColumnResizer.initColumnSizes(this.table, this.getMyModel().getLongValues());
    }

    protected void setupTableCellRenderers() {
        this.table.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        ResourceColumnRenderer resourceColumnRenderer = new ResourceColumnRenderer(){
            private static final long serialVersionUID = -9048767156104266422L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Time time = (Time)object;
                String string = String.format("%.1f %s", time.getContentInUnits(Time.UNIT_MS), Time.UNIT_MS);
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        };
        this.table.setDefaultRenderer(Time.class, resourceColumnRenderer);
    }
}

