/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.bott;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.BOInfo;
import alma.obsprep.bo.BOIntrospector;
import alma.obsprep.bo.BOPropertyDescriptor;
import alma.obsprep.ot.gui.bott.AbstractTreeTableModel;
import alma.obsprep.ot.gui.bott.BOTreeNode;
import alma.obsprep.ot.gui.bott.TreeTableModel;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class BOLargeTTModel
extends AbstractTreeTableModel {
    private String[] columns;

    public BOLargeTTModel(BusinessObject businessObject) throws IntrospectionException {
        super(new BOTreeNode(businessObject));
        this.init((BOTreeNode)this.root);
    }

    private void addChildBO(BOTreeNode bOTreeNode, BusinessObject businessObject, Map<BusinessObject, BOTreeNode> map) throws IntrospectionException {
        BOTreeNode bOTreeNode2 = new BOTreeNode(businessObject);
        bOTreeNode.add(bOTreeNode2);
        this.computeChildren(bOTreeNode2, map);
    }

    private void collectFieldNames(Class<?> clazz, Map<String, Integer> map, Map<Class<?>, Class<?>> map2) throws IntrospectionException {
        if (map2.get(clazz) != null) {
            return;
        }
        map2.put(clazz, clazz);
        BOInfo bOInfo = BOIntrospector.getBOInfo(clazz);
        String[] stringArray = bOInfo.getSimplePropertyNames();
        Object[] objectArray = stringArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i];
            Object object = map.get(string);
            object = object == null ? Integer.valueOf(1) : Integer.valueOf((Integer)object + 1);
            map.put(string, (Integer)object);
        }
        for (Object object : objectArray = bOInfo.getChildClasses()) {
            this.collectFieldNames((Class<?>)object, map, map2);
        }
    }

    protected void computeChildren(BOTreeNode bOTreeNode) throws IntrospectionException {
        this.computeChildren(bOTreeNode, new HashMap<BusinessObject, BOTreeNode>());
    }

    private void computeChildren(BOTreeNode bOTreeNode, Map<BusinessObject, BOTreeNode> map) throws IntrospectionException {
        BOPropertyDescriptor[] bOPropertyDescriptorArray;
        if (bOTreeNode == null) {
            return;
        }
        map.put(bOTreeNode.getBusinessObject(), bOTreeNode);
        BusinessObject businessObject = bOTreeNode.getBusinessObject();
        BOInfo bOInfo = BOIntrospector.getBOInfo(businessObject.getClass());
        for (BOPropertyDescriptor bOPropertyDescriptor : bOPropertyDescriptorArray = bOInfo.getProperties()) {
            if (!bOPropertyDescriptor.isBusinessObject()) continue;
            try {
                BusinessObject businessObject2;
                Method method = bOPropertyDescriptor.getReadMethod();
                Object object = method.invoke((Object)businessObject, (Object[])null);
                if (object == null || map.get(object) != null) continue;
                if (object.getClass().isArray()) {
                    for (BusinessObject businessObject3 : businessObject2 = (BusinessObject)object) {
                        this.addChildBO(bOTreeNode, businessObject3, map);
                    }
                    continue;
                }
                businessObject2 = (BusinessObject)object;
                this.addChildBO(bOTreeNode, businessObject2, map);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public Object getChild(Object object, int n) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        BOTreeNode bOTreeNode2 = (BOTreeNode)bOTreeNode.getChildAt(n);
        return bOTreeNode2;
    }

    @Override
    public int getChildCount(Object object) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        int n = bOTreeNode.getChildCount();
        return n;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length + 1;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "";
        }
        return this.columns[n - 1];
    }

    public BOTreeNode[] computePathToRoot(BOTreeNode bOTreeNode) {
        Stack<BOTreeNode> stack = new Stack<BOTreeNode>();
        this.recurseToRoot(bOTreeNode, stack);
        BOTreeNode[] bOTreeNodeArray = stack.toArray(new BOTreeNode[stack.size()]);
        return bOTreeNodeArray;
    }

    private void recurseToRoot(BOTreeNode bOTreeNode, Stack<BOTreeNode> stack) {
        if (bOTreeNode == null) {
            return;
        }
        stack.add(0, bOTreeNode);
        this.recurseToRoot((BOTreeNode)bOTreeNode.getParent(), stack);
    }

    @Override
    public Object getValueAt(Object object, int n) {
        if (n == 0) {
            return null;
        }
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        String string = this.getColumnName(n);
        Object object2 = bOTreeNode.getFieldValue(string);
        return object2;
    }

    private void init(BOTreeNode bOTreeNode) throws IntrospectionException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap hashMap2 = new HashMap();
        this.collectFieldNames(bOTreeNode.getBusinessObject().getClass(), hashMap, hashMap2);
        this.columns = this.sort(hashMap);
        this.computeChildren(bOTreeNode);
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        if (n == 0) {
            return true;
        }
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        String string = this.getColumnName(n);
        return bOTreeNode.hasProperty(string);
    }

    @Override
    public boolean isLeaf(Object object) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        boolean bl = bOTreeNode.isLeaf();
        return bl;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    private String[] sort(Map<String, Integer> map) {
        int n;
        ColumnName[] columnNameArray = new ColumnName[map.size()];
        int n2 = 0;
        for (String stringArray2 : map.keySet()) {
            n = map.get(stringArray2);
            columnNameArray[n2++] = new ColumnName(this, stringArray2, n);
        }
        Comparator comparator = (columnName, columnName2) -> {
            int n;
            ColumnName columnName3 = columnName;
            ColumnName columnName4 = columnName2;
            int n2 = columnName3.getFrequency();
            if (n2 != (n = columnName4.getFrequency())) {
                return n - n2;
            }
            return columnName3.getName().compareTo(columnName4.getName());
        };
        Arrays.sort(columnNameArray, comparator);
        String[] stringArray = new String[columnNameArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = columnNameArray[n].getName();
        }
        return stringArray;
    }

    private class ColumnName {
        private final int freq;
        private final String name;

        ColumnName(BOLargeTTModel bOLargeTTModel, String string, int n) {
            this.name = string;
            this.freq = n;
        }

        int getFrequency() {
            return this.freq;
        }

        String getName() {
            return this.name;
        }
    }
}

