/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.preferences;

import alma.obsprep.obstooluserprefs.DialogSettings;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.preferences.AbstractPanel;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.util.GUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import lombok.NonNull;

public class DialogsPanel
extends AbstractPanel
implements PreferencesReadWrite {
    private TableModel tableModel;
    private ArrayList<DialogDescription> dialogDescriptions = new ArrayList();

    public DialogsPanel() {
        this.initialize();
    }

    void initialize() {
        JPanel jPanel = new JPanel();
        this.setName("DialogPrefs");
        jPanel.setLayout(new BorderLayout());
        this.tableModel = new TableModel();
        Table table = new Table(this.tableModel);
        table.setName("DialogPrefs.tblDialogs");
        table.setToolTipText("Uncheck boxes to turn off dialogs");
        table.setShowVerticalLines(false);
        table.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tableColumnModel = table.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(25);
        JScrollPane jScrollPane = new JScrollPane(table, 20, 31);
        jPanel.add((Component)jScrollPane, "Center");
        this.addStripe("Wanted Dialogs", jPanel, false);
    }

    @Override
    public void readPreferences(@NonNull ObsToolUserPrefs obsToolUserPrefs) {
        if (obsToolUserPrefs == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        ArrayList arrayList = new ArrayList();
        for (DialogId dialogId : GUIUtilities.dialogIds()) {
            boolean bl = Stream.of(obsToolUserPrefs.getDialogSettings()).noneMatch(dialogSettings -> dialogSettings.getDialogId().equals(dialogId.getId()));
            if (!bl) continue;
            obsToolUserPrefs.addDialogSettings(GUIUtilities.dialogSettings(dialogId));
        }
        for (DialogId dialogId : GUIUtilities.dialogIds()) {
            DialogSettings dialogSettings2 = GUIUtilities.dialogSettings(dialogId);
            int n = (int)dialogSettings2.getAutoanswer();
            Stream.of(obsToolUserPrefs.getDialogSettings()).filter(dialogSettings -> dialogSettings.getDialogId().equals(dialogId.getId())).findFirst().ifPresent(dialogSettings -> arrayList.add(new DialogDescription(this, dialogSettings.getDialogId(), dialogSettings.getDescription(), !dialogSettings.getSuppress(), n)));
        }
        this.dialogDescriptions = arrayList;
        this.tableModel.fireTableDataChanged();
    }

    private void addDialogToModel(@NonNull DialogSettings dialogSettings, @NonNull ObsToolUserPrefs obsToolUserPrefs) {
        if (dialogSettings == null) {
            throw new NullPointerException("dialogSettings is marked non-null but is null");
        }
        if (obsToolUserPrefs == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        obsToolUserPrefs.addDialogSettings(dialogSettings);
    }

    @Override
    public void writePreferences(@NonNull ObsToolUserPrefs obsToolUserPrefs) {
        if (obsToolUserPrefs == null) {
            throw new NullPointerException("obsToolUserPrefs is marked non-null but is null");
        }
        if (this.dialogDescriptions.isEmpty()) {
            this.readPreferences(obsToolUserPrefs);
        }
        obsToolUserPrefs.removeAllFavoriteDirectory();
        obsToolUserPrefs.removeAllDialogSettings();
        Set<DialogId> set = GUIUtilities.dialogIds();
        for (DialogDescription dialogDescription : this.dialogDescriptions) {
            DialogSettings dialogSettings = new DialogSettings();
            dialogSettings.setDialogId(dialogDescription.name);
            dialogSettings.setDescription(dialogDescription.description);
            dialogSettings.setSuppress(!dialogDescription.isDialogWanted);
            dialogSettings.setAutoanswer((long)dialogDescription.answer);
            obsToolUserPrefs.addDialogSettings(dialogSettings);
            set.stream().filter(dialogId -> dialogId.getDescription().equals(dialogDescription.name)).findFirst().ifPresent(dialogId -> {
                dialogId.setDescription(dialogDescription.description);
                dialogId.setId(dialogDescription.name);
                dialogId.setSuppressed(!dialogDescription.isDialogWanted);
            });
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "  ";
                }
                case 1: {
                    return "Dialog";
                }
            }
            return "???";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DialogsPanel.this.dialogDescriptions.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DialogDescription dialogDescription = DialogsPanel.this.dialogDescriptions.get(n);
            switch (n2) {
                case 0: {
                    return dialogDescription.isDialogWanted ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return dialogDescription.description;
                }
            }
            return "???";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DialogDescription dialogDescription = DialogsPanel.this.dialogDescriptions.get(n);
            if (n2 == 0) {
                dialogDescription.isDialogWanted = (Boolean)object;
            }
        }
    }

    private class DialogDescription {
        private String name;
        private String description;
        private boolean isDialogWanted;
        private int answer;

        public DialogDescription(DialogsPanel dialogsPanel, String string, String string2, boolean bl, int n) {
            this.name = string;
            this.description = string2;
            this.isDialogWanted = bl;
            this.answer = n;
        }

        public String toString() {
            return "DialogsPanel.DialogDescription(name=" + this.name + ", description=" + this.description + ", isDialogWanted=" + this.isDialogWanted + ", answer=" + this.answer + ")";
        }
    }
}

