/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.sciencegoals.SgNoteEditor;
import alma.obsprep.ot.models.misc.ExpertParametersModel;
import lombok.NonNull;

public class SgNoteModel
extends Model {
    @NonNull
    private final ExpertParametersModel expertParametersModel = new ExpertParametersModel(null);

    public SgNoteModel(ScienceGoal scienceGoal) {
        super(scienceGoal);
        this.registerSubModel(this.expertParametersModel);
    }

    public ScienceGoal getScienceGoal() {
        return (ScienceGoal)this.getDocument();
    }

    @Override
    public void publish() {
        if (this.getScienceGoal() != null) {
            this.publish(SgNoteEditor.FID_NAME, this.getScienceGoal().getName());
            this.publish(SgNoteEditor.FID_NOTE, this.getScienceGoal().getNote());
            this.publish(SgNoteEditor.FID_SG_DESCOPED, this.getScienceGoal().getIsDescoped());
            this.publish(SgNoteEditor.FID_IS_RESUBMISSION, this.getScienceGoal().getIsResubmission());
        }
        this.expertParametersModel.publish();
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        this.expertParametersModel.setDocument(object);
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (fieldID.equals(SgNoteEditor.FID_NAME)) {
            String string = (String)object;
            if (string == null || string.equals("")) {
                string = "Science Goal";
            }
            scienceGoal.setName(string);
            return string;
        }
        if (fieldID.equals(SgNoteEditor.FID_NOTE)) {
            String string = (String)object;
            scienceGoal.setNote(string);
            return string;
        }
        if (fieldID.equals(SgNoteEditor.FID_SG_DESCOPED)) {
            boolean bl = (Boolean)object;
            scienceGoal.setIsDescoped(bl);
            return bl;
        }
        if (fieldID.equals(SgNoteEditor.FID_IS_RESUBMISSION)) {
            boolean bl = (Boolean)object;
            scienceGoal.setIsResubmission(bl);
            return bl;
        }
        return object;
    }

    @NonNull
    public ExpertParametersModel getExpertParametersModel() {
        return this.expertParametersModel;
    }
}

