/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.others;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsreview.ObsReview;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.util.MiscUtils;
import alma.scheduling.ousstatus.OUSStatus;
import alma.scheduling.projectstatus.ProjectStatus;
import alma.scheduling.sbstatus.SBStatus;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TestEntityRefsNotBrokenValidator
extends AbstractValidator {
    private static final String ME = "chk04: ";

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Method[] methodArray;
        for (Method method : methodArray = businessObject.getClass().getMethods()) {
            if (!method.getName().startsWith("gettrue")) continue;
            try {
                if (Entity.class.isAssignableFrom(method.getReturnType())) {
                    try {
                        method.invoke((Object)businessObject, (Object[])null);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (!(invocationTargetException.getTargetException() instanceof UnknownEntityException)) continue;
                        if (ProjectStatus.class.isAssignableFrom(method.getReturnType()) || OUSStatus.class.isAssignableFrom(method.getReturnType()) || SBStatus.class.isAssignableFrom(method.getReturnType()) || ObsAttachment.class.isAssignableFrom(method.getReturnType()) || ObsReview.class.isAssignableFrom(method.getReturnType())) {
                            problemListModel.add(DefaultProblem.createInfo("chk04: Dangling link from " + MiscUtils.classname(businessObject) + " to entity " + method.getReturnType().getSimpleName(), MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
                            continue;
                        }
                        problemListModel.add(DefaultProblem.createError("chk04: Broken link from " + MiscUtils.classname(businessObject) + " to entity " + method.getReturnType().getSimpleName(), MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
                    }
                    continue;
                }
                if (!EntityPart.class.isAssignableFrom(method.getReturnType())) continue;
                try {
                    method.invoke((Object)businessObject, (Object[])null);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!(invocationTargetException.getTargetException() instanceof UnknownEntityPartException)) continue;
                    problemListModel.add(DefaultProblem.createError("chk04: Broken link from " + MiscUtils.classname(businessObject) + " to part " + method.getReturnType().getSimpleName(), MiscUtils.packageClassnameHash(businessObject), (IBusinessObject)businessObject));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

