/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.SkyCoordinates;
import java.util.List;
import lombok.NonNull;

public class ClusterGeometricMeanCalculator {
    public SkyCoordinates getGeometricMeanOfCluster(@NonNull ScienceGoal scienceGoal) throws UnableToCalculateGeometricMeanException {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        int n = scienceGoal.getTargetParametersCount();
        if (n == 1) {
            return scienceGoal.getTargetParameters(0).getSourceCoordinates().getICRSSkyCoordinates();
        }
        List<ScienceGoal.SourcePoint> list = scienceGoal.getAllSiderealSourceFieldCentres();
        if (list.size() != n) {
            throw new UnableToCalculateGeometricMeanException("Sidereal targets in science goal");
        }
        return this.getMeanGeometricCoordinates(list);
    }

    public SkyCoordinates getMeanGeometricCoordinates(List<ScienceGoal.SourcePoint> list) {
        List<RectangleCoordinates> list2 = list.stream().map(this::getDecomposedRectangularCoordinates).toList();
        int n = list.size();
        double d = list2.stream().mapToDouble(rectangleCoordinates -> rectangleCoordinates.x).sum() / (double)n;
        double d2 = list2.stream().mapToDouble(rectangleCoordinates -> rectangleCoordinates.y).sum() / (double)n;
        double d3 = list2.stream().mapToDouble(rectangleCoordinates -> rectangleCoordinates.z).sum() / (double)n;
        double d4 = Math.asin(d3);
        double d5 = Math.atan2(d, d2);
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        skyCoordinates.setAbsoluteCoordinatesInICRSDeg(Math.toDegrees(d5), Math.toDegrees(d4));
        return skyCoordinates;
    }

    private RectangleCoordinates getDecomposedRectangularCoordinates(@NonNull ScienceGoal.SourcePoint sourcePoint) {
        if (sourcePoint == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        SkyPoint skyPoint = sourcePoint.getSkyPoint();
        double d = Math.toRadians(skyPoint.getX());
        double d2 = Math.toRadians(skyPoint.getY());
        double d3 = Math.sin(d) * Math.cos(d2);
        double d4 = Math.cos(d) * Math.cos(d2);
        double d5 = Math.sin(d2);
        return new RectangleCoordinates(d3, d4, d5);
    }

    public class UnableToCalculateGeometricMeanException
    extends Exception {
        public UnableToCalculateGeometricMeanException(String string) {
            super(string);
        }
    }

    private record RectangleCoordinates(double x, double y, double z) {
    }
}

