/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.configuration.ReferencePositionOffset;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockConfiguratorInterface;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class InterferometericSolarSBConfigurator
implements SchedBlockConfiguratorInterface {
    private final SchedBlock sb;
    @NonNull
    private final SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult;

    @Override
    public void configureSB() {
        this.setInterferometricSBParameters();
    }

    private void configureInterferometricIntegrationTimeOnSource() {
        List<Target> list = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        int n = list.size();
        for (Target target : list) {
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)((Time)this.solarExecutionTimeResult.t_t_EB.divide(n)).getMins(), (String)IntTimeSource.UNIT_MIN));
            }
        }
    }

    private void configureInterferometricPhaseCalibratorCycleTime() {
        List<Target> list = this.sb.getAllTargets(Optional.empty());
        for (ObservingGroup observingGroup : this.sb.getObservingGroup()) {
            for (Target target2 : observingGroup.getAllOrderedTargets(Optional.of(Target::hasPhaseCalParameters))) {
                SpectralSpec spectralSpec = target2.getSpectralSpec();
                Optional<Target> optional = list.stream().filter(target -> target.hasScienceParameters() && target.getSpectralSpec().equals(spectralSpec)).findFirst();
                long l = list.stream().filter(target -> target.hasScienceParameters() && target.getSpectralSpec().equals(spectralSpec)).count();
                boolean bl = false;
                bl |= l > 1L;
                if (optional.isPresent()) {
                    PhaseCalParameters[] phaseCalParametersArray = optional.get();
                    bl |= phaseCalParametersArray.getFieldSource().getNumberOfPointings() > 1;
                }
                if (!bl) continue;
                for (PhaseCalParameters phaseCalParameters : target2.getPhaseCalParametersList()) {
                    phaseCalParameters.setCycleTime(Time.createTimeMin(5.0));
                }
            }
        }
    }

    private void configureInterferometricScienceReferencePosition() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        for (Target target : this.sb.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            int n = target.getSpectralSpec().getReceiverBand().getNumber();
            for (Reference reference : target.getFieldSource().getReference()) {
                SkyCoordinates skyCoordinates = reference.getReferenceCoordinates();
                try {
                    AlmaCapabilities.ReferenceOffset referenceOffset = almaCapabilities.getInterferometricReferenceOffset(ReferencePositionOffset.SOLAR, n);
                    skyCoordinates.setLatitude(referenceOffset.latitude());
                    skyCoordinates.setLongitude(referenceOffset.longitude());
                }
                catch (AlmaCapabilities.UnableToFindOffsetException unableToFindOffsetException) {
                    Log.logger(InterferometericSolarSBConfigurator.class).warning("Unable to find the reference position coordinates for rxb " + n);
                    throw new WizardSBGenerationException(unableToFindOffsetException);
                }
                reference.setIntegrationTime(Time.createTimeSec(12.0));
            }
        }
    }

    private void configureInterferometricScienceSubscanDuration() {
        for (ObservingGroup observingGroup : this.sb.getObservingGroup()) {
            for (Target target : observingGroup.getAllOrderedTargets(Optional.of(Target::hasScienceParameters))) {
                int n = target.getFieldSource().getNumberOfPointings();
                for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                    double d = n == 1 ? 30.24 : 6.048;
                    scienceParameters.setSubScanDuration(Time.createTimeSec(d));
                }
            }
        }
    }

    private void setInterferometricSBParameters() {
        this.configureInterferometricScienceReferencePosition();
        this.configureInterferometricScienceSubscanDuration();
        this.configureInterferometricPhaseCalibratorCycleTime();
        this.configureInterferometricIntegrationTimeOnSource();
        this.sb.getSchedBlockControl().setExecutionCount(this.solarExecutionTimeResult.n_EB_int);
    }

    public InterferometericSolarSBConfigurator(SchedBlock schedBlock, @NonNull SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult) {
        if (solarExecutionTimeResult == null) {
            throw new NullPointerException("solarExecutionTimeResult is marked non-null but is null");
        }
        this.sb = schedBlock;
        this.solarExecutionTimeResult = solarExecutionTimeResult;
    }
}

