/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.ousgenerator;

import alma.obsprep.bo.obsproject.CalibrationRequirements;
import alma.obsprep.bo.obsproject.ControlBlock;
import alma.obsprep.bo.obsproject.DataProcessingParameters;
import alma.obsprep.bo.obsproject.FlowControl;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.UnitDependencies;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;
import alma.valuetypes.Angle;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;

class ObservatoryGoalOUSGenerator
implements OUSGenerator {
    private final ObservatoryGoal goal;

    ObservatoryGoalOUSGenerator(ObservatoryGoal observatoryGoal) {
        this.goal = observatoryGoal;
    }

    private void configure(CalibrationRequirements calibrationRequirements) {
        calibrationRequirements.setPointingAccuracy(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
    }

    private void configure(DataProcessingParameters dataProcessingParameters) {
        dataProcessingParameters.setProjectType("Continuum");
        dataProcessingParameters.setAngularResolution(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
        Velocity velocity = Velocity.createVelocity();
        velocity.setReferenceSystem(Velocity.REFERENCESYSTEM_LSRK);
        velocity.setDopplerCalcType(Velocity.DOPPLERCALCTYPE_OPTICAL);
        velocity.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
        dataProcessingParameters.setVelocityResolution(velocity);
        dataProcessingParameters.setTBSensitivityGoal(Temperature.createTemperature((double)0.0, (String)Temperature.UNIT_K));
        dataProcessingParameters.setRMSGoal(Sensitivity.createSensitivity((double)0.0, (String)Sensitivity.UNIT_JY));
    }

    private void configure(FlowControl flowControl) {
        flowControl.setControlScript("");
    }

    private void configure(ObsUnitControl obsUnitControl) {
        obsUnitControl.setArrayRequested(ControlBlock.ARRAYREQUESTED_TWELVE_M);
        obsUnitControl.setMaximumTime(Time.createTime((double)0.0, (String)Time.UNIT_S));
        obsUnitControl.setEstimatedExecutionTime(Time.createTime((double)0.0, (String)Time.UNIT_S));
        this.configure(obsUnitControl.getCalibrationRequirements());
    }

    private void configure(ObsUnitSet obsUnitSet) {
        obsUnitSet.setName(this.goal.getPurpose());
        obsUnitSet.setScienceProcessingScript("");
        obsUnitSet.setRunSciencePipeline(false);
        this.configure(obsUnitSet.getObsUnitControl());
        this.configure(obsUnitSet.getUnitDependencies());
        this.configure(obsUnitSet.getDataProcessingParameters());
        this.configure(obsUnitSet.getFlowControl());
    }

    private void configure(UnitDependencies unitDependencies) {
        unitDependencies.setExecutionCount(1);
        unitDependencies.setDelay(Time.createTime((double)0.0, (String)Time.UNIT_S));
        unitDependencies.setExpression("");
    }

    @Override
    public ObsUnitSet getGroupOUS() {
        ObsUnitSet obsUnitSet = ObsUnitSet.createObsUnitSet();
        obsUnitSet.setName(this.goal.getName() + ": Group OUS");
        return obsUnitSet;
    }

    @Override
    public ObsUnitSet getMemberOUS() {
        ObsUnitSet obsUnitSet = ObsUnitSet.createObsUnitSet();
        this.configure(obsUnitSet);
        return obsUnitSet;
    }

    @Override
    public ObsUnitSet getRootOUS() {
        ObsUnitSet obsUnitSet = ObsUnitSet.createObsUnitSet();
        obsUnitSet.setName(this.goal.getName() + ": Root OUS");
        return obsUnitSet;
    }
}

