/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.userlookup;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class JsonMarshaller<T> {
    protected final ObjectMapper jsonMapper = new ObjectMapper();
    protected final Class<?> type;

    public <S extends T> JsonMarshaller(Class<S> clazz) {
        this.configure();
        this.type = clazz;
    }

    protected void configure() {
        this.jsonMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
        this.jsonMapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String toJson(Object object) throws JsonProcessingException {
        String string = this.jsonMapper.writeValueAsString(object);
        return string;
    }

    public T fromJSON(String string) throws IOException {
        String string2 = string.replaceAll("\\p{Cntrl}", " ");
        Object object = this.jsonMapper.readValue(string2, this.type);
        return (T)object;
    }

    public <C extends Collection<T>> C fromJsonCollection(Class<C> clazz, String string) throws IOException {
        String string2 = string.replaceAll("\\p{Cntrl}", " ");
        CollectionType collectionType = this.jsonMapper.getTypeFactory().constructCollectionType(clazz, this.type);
        Collection collection = (Collection)this.jsonMapper.readValue(string2, (JavaType)collectionType);
        return (C)collection;
    }

    public <C extends Map<?, T>> C fromJsonMap(Class<C> clazz, String string) throws IOException {
        String string2 = string.replaceAll("\\p{Cntrl}", " ");
        MapType mapType = this.jsonMapper.getTypeFactory().constructMapType(clazz, Object.class, this.type);
        Map map = (Map)this.jsonMapper.readValue(string2, (JavaType)mapType);
        return (C)map;
    }
}

