<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:opl="Alma/ObsPrep/ObsProposal"
                xmlns:oat="Alma/Obsprep/ObsAttachment">

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<!-- Simply modify the schemaversion no. and entity -->
  
<xsl:template match="oat:ObsAttachment">
<ObsAttachment xmlns="Alma/Obsprep/ObsAttachment">
  <xsl:attribute name="schemaVersion">9</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="@revision"/></xsl:attribute>
  <xsl:attribute name="xsi:type">ObsAttachment</xsl:attribute>
  <xsl:apply-templates select="node()"/>
  <xsl:comment>Converted to V9 by ObsAttachment8-9.xslt</xsl:comment>

</ObsAttachment>
</xsl:template>

<xsl:template match="oat:ObsAttachmentEntity">
<ObsAttachmentEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="documentVersion"><xsl:value-of select="@documentVersion"/></xsl:attribute>
<xsl:attribute name="timestamp"><xsl:value-of select="@timestamp"/></xsl:attribute>
<xsl:attribute name="schemaVersion">9</xsl:attribute>
</ObsAttachmentEntity>
</xsl:template>

</xsl:stylesheet>
